/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.DataPointMemoryCompressionTracker;
import com.hazelcast.webmonitor.metrics.impl.InternalStorageException;
import com.hazelcast.webmonitor.metrics.impl.MinuteBucket;
import com.hazelcast.webmonitor.metrics.impl.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.PersistentStore;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBLoader;
import com.hazelcast.webmonitor.metrics.impl.serde.MinuteSeriesSerde;
import com.hazelcast.webmonitor.metrics.impl.serde.MinuteStartIdSerde;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TtlDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RocksDBStore
implements PersistentStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBStore.class);
    static final String STORE_SUBDIR = "datapoints";
    private final MinuteStartIdSerde keySerde = new MinuteStartIdSerde();
    private final MinuteSeriesSerde valueSerde = new MinuteSeriesSerde();
    private final Path path;
    private final RocksDB store;
    private final ReadWriteLock closeInProgressLock = new ReentrantReadWriteLock();
    private boolean closed;
    private final DataPointMemoryCompressionTracker dataPointMemoryCompressionTracker;

    public RocksDBStore(Path dir, Duration ttl, DataPointMemoryCompressionTracker dataPointMemoryCompressionTracker) throws InternalStorageException.InternalLoadNativeException, InternalStorageException.InternalOpenOrCreateStoreException {
        RocksDBLoader.loadLibrary();
        this.path = dir.resolve("datapoints");
        this.store = RocksDBStore.openOrCreateStore((Path)this.path, (Duration)ttl);
        this.dataPointMemoryCompressionTracker = dataPointMemoryCompressionTracker;
    }

    public void putAll(List<MinuteBucket> buckets) throws InternalStorageException.InternalClosedStoreException, InternalStorageException.InternalPersistenceException {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            try (WriteOptions writeOptions = new WriteOptions();
                 WriteBatch batch = new WriteBatch();){
                for (MinuteBucket bucket : buckets) {
                    byte[] keyBinary = this.keySerde.serialize((Object)bucket.minStartId());
                    AtomicLongArray values = bucket.rawValues();
                    this.dataPointMemoryCompressionTracker.addInMemorySize((long)values.length() * 8L);
                    byte[] valueBinary = this.valueSerde.serialize((Object)values);
                    this.dataPointMemoryCompressionTracker.addOnDiskSize((long)valueBinary.length);
                    batch.put(keyBinary, valueBinary);
                }
                this.store.write(writeOptions, batch);
                this.store.flushWal(true);
            }
        }
        catch (RocksDBException e) {
            throw new InternalStorageException.InternalPersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    public long[] get(MinuteStartId minStartId) throws InternalStorageException.InternalClosedStoreException, InternalStorageException.InternalPersistenceException {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            byte[] keyBinary = this.keySerde.serialize((Object)minStartId);
            byte[] rawValue = this.store.get(keyBinary);
            if (rawValue == null) {
                long[] lArray = null;
                return lArray;
            }
            long[] lArray = (long[])this.valueSerde.deserialize(rawValue);
            return lArray;
        }
        catch (RocksDBException e) {
            throw new InternalStorageException.InternalPersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    void compactRange() throws InternalStorageException.InternalClosedStoreException, InternalStorageException.InternalPersistenceException {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            this.store.compactRange();
        }
        catch (RocksDBException e) {
            throw new InternalStorageException.InternalPersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    public void close() {
        this.closeInProgressLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.store.closeE();
        }
        catch (Exception e) {
            log.warn("Could not close metrics store {}.", (Object)this.path, (Object)e);
        }
        finally {
            this.closeInProgressLock.writeLock().unlock();
        }
    }

    private void ensureOpen() throws InternalStorageException.InternalClosedStoreException {
        if (this.closed) {
            throw new InternalStorageException.InternalClosedStoreException("Store is already closed.");
        }
    }

    private static RocksDB openOrCreateStore(Path path, Duration ttl) throws InternalStorageException.InternalOpenOrCreateStoreException {
        TtlDB ttlDB;
        block8: {
            Options options = new Options().setCreateIfMissing(true).setMaxLogFileSize(0x500000L).setKeepLogFileNum(10L).setPeriodicCompactionSeconds(ttl.getSeconds()).setWriteBufferSize(0x8000000L).setManualWalFlush(true);
            try {
                ttlDB = TtlDB.open((Options)options, (String)path.toAbsolutePath().toString(), (int)((int)ttl.getSeconds()), (boolean)false);
                if (options == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (options != null) {
                        try {
                            options.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new InternalStorageException.InternalOpenOrCreateStoreException(path, (Throwable)e);
                }
            }
            options.close();
        }
        return ttlDB;
    }
}

