/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.metrics.Tags;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Tags
implements Iterable<Tag>,
Serializable {
    public static final Tags EMPTY = new Tags(new String[0], new String[0]);
    private final Tag[] tagsContainer;

    public Tags() {
        this.tagsContainer = new Tag[0];
    }

    public Tags(String[] names, String[] values) {
        Objects.requireNonNull(names, "Tag names array must be set");
        Objects.requireNonNull(values, "Tag values array must be set");
        if (names.length != values.length) {
            throw new IllegalArgumentException("Tag names and values array sizes must match");
        }
        this.tagsContainer = new Tag[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.tagsContainer[i] = new Tag(names[i], values[i]);
        }
        Arrays.sort(this.tagsContainer);
    }

    private Tags(Tag[] tags) {
        this.tagsContainer = tags;
    }

    public Optional<Tag> getTag(String tagName) {
        for (Tag tag : this.tagsContainer) {
            if (!tag.getName().equals(tagName)) continue;
            return Optional.of(tag);
        }
        return Optional.empty();
    }

    public int size() {
        return this.tagsContainer.length;
    }

    public Tags add(String name, String value) {
        Object[] copy = new Tag[this.size() + 1];
        System.arraycopy(this.tagsContainer, 0, copy, 0, this.size());
        copy[this.size()] = new Tag(name, value);
        Arrays.sort(copy);
        return new Tags((Tag[])copy);
    }

    @Override
    public Iterator<Tag> iterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Stream<Tag> stream() {
        int characteristics = 17749;
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.tagsContainer.length, characteristics), false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tags entries = (Tags)o;
        return Arrays.equals(this.tagsContainer, entries.tagsContainer);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tagsContainer);
    }

    public String toString() {
        return "Tags{tags=" + Arrays.toString(this.tagsContainer) + '}';
    }

    static /* synthetic */ Tag[] access$000(Tags x0) {
        return x0.tagsContainer;
    }
}

