/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.metrics.MetricAware;
import com.hazelcast.webmonitor.metrics.Tags;
import java.util.Objects;

public final class Query
implements MetricAware {
    private final String metric;
    private final Tags tags;
    private final long start;
    private final long end;

    public Query(String metric, Tags tags, long start, long end) {
        this.metric = Objects.requireNonNull(metric, "Metric name must be set");
        this.tags = Objects.requireNonNull(tags, "Tags must be set");
        this.start = start;
        this.end = end;
    }

    public String getName() {
        return this.metric;
    }

    public Tags getTags() {
        return this.tags;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return this.start == query.start && this.end == query.end && this.metric.equals(query.metric) && this.tags.equals((Object)query.tags);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.tags, this.start, this.end);
    }

    public String toString() {
        return "Query{metric='" + this.metric + '\'' + ", tags=" + this.tags + ", start=" + this.start + ", end=" + this.end + '}';
    }
}

