/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DataPointSeries
implements Iterable<DataPointAware> {
    private static final DataPointSeries EMPTY = new DataPointSeries(new long[0], new long[0], DataPointType.LONG);
    private final InternalDataPoint[] dataPoints;
    private final DataPointType type;

    public DataPointSeries(long[] times, long[] values, DataPointType type) {
        Objects.requireNonNull(times, "Times array must be set");
        Objects.requireNonNull(values, "Values array must be set");
        this.type = Objects.requireNonNull(type, "Type must be set");
        if (values.length != times.length) {
            throw new IllegalArgumentException("Time and value array sizes must match");
        }
        this.dataPoints = new InternalDataPoint[times.length];
        long lastTime = Long.MIN_VALUE;
        for (int i = 0; i < times.length; ++i) {
            long time = times[i];
            if (lastTime >= time) {
                throw new IllegalArgumentException("Time must be monotonically increasing");
            }
            lastTime = time;
            this.dataPoints[i] = new InternalDataPoint(this, time, values[i]);
        }
    }

    public DataPointType getType() {
        return this.type;
    }

    @Override
    public Iterator<DataPointAware> iterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Stream<DataPointAware> stream() {
        int characteristics = 17749;
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.dataPoints.length, characteristics), false);
    }

    public int size() {
        return this.dataPoints.length;
    }

    public boolean isEmpty() {
        return this.dataPoints.length == 0;
    }

    public Optional<DataPointAware> getEarliestDataPoint() {
        return this.dataPoints.length > 0 ? Optional.of(this.dataPoints[0]) : Optional.empty();
    }

    public Optional<DataPointAware> getLatestDataPoint() {
        return this.dataPoints.length > 0 ? Optional.of(this.dataPoints[this.dataPoints.length - 1]) : Optional.empty();
    }

    public static DataPointSeries empty() {
        return EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPointSeries series = (DataPointSeries)o;
        return this.type == series.type && Arrays.equals(this.dataPoints, series.dataPoints);
    }

    public int hashCode() {
        return Objects.hash(this.type, Arrays.hashCode(this.dataPoints));
    }

    public String toString() {
        return "DataPointSeries{type=" + this.type + ", dataPoints=" + Arrays.toString(this.dataPoints) + '}';
    }

    static /* synthetic */ InternalDataPoint[] access$000(DataPointSeries x0) {
        return x0.dataPoints;
    }

    static /* synthetic */ DataPointType access$100(DataPointSeries x0) {
        return x0.type;
    }
}

