/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events;

import com.google.common.collect.EvictingQueue;
import com.hazelcast.webmonitor.events.model.AbstractWanEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WanEventStore
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WanEventStore.class);
    private static final int MAX_EVENTS_PER_CLUSTER = 10000;
    private final HashMap<String, EvictingQueue<AbstractWanEvent>> store = new HashMap();
    private final HashMap<String, Long> lastUpdated = new HashMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "EventStoreCleanup"));
    private final int maxEventsPerCluster;

    public WanEventStore() {
        this(1L, TimeUnit.HOURS, 10000);
    }

    WanEventStore(long cleanupDelay, TimeUnit cleanupTimeUnit, int maxEventsPerCluster) {
        this.maxEventsPerCluster = maxEventsPerCluster;
        this.executor.scheduleWithFixedDelay(() -> {
            Set<String> clustersToBeRemoved;
            long oldestTimestampAllowed = System.currentTimeMillis() - cleanupTimeUnit.toMillis(cleanupDelay);
            this.wLock.lock();
            try {
                clustersToBeRemoved = this.lastUpdated.entrySet().stream().filter(entry -> (Long)entry.getValue() < oldestTimestampAllowed).map(Map.Entry::getKey).collect(Collectors.toSet());
                clustersToBeRemoved.forEach(cluster -> {
                    this.store.remove(cluster);
                    this.lastUpdated.remove(cluster);
                });
            }
            finally {
                this.wLock.unlock();
            }
            if (!clustersToBeRemoved.isEmpty()) {
                log.info("Events for the following clusters are being deleted as no events have been received from them since {} : {}.", (Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(oldestTimestampAllowed), TimeZone.getDefault().toZoneId()), clustersToBeRemoved);
            }
        }, cleanupDelay, cleanupDelay, cleanupTimeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String cluster, List<AbstractWanEvent> events) {
        this.wLock.lock();
        try {
            this.lastUpdated.put(cluster, System.currentTimeMillis());
            EvictingQueue eventQueue = this.store.getOrDefault(cluster, EvictingQueue.create((int)this.maxEventsPerCluster));
            eventQueue.addAll(events);
            this.store.put(cluster, eventQueue);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWanEvent[] getEventsForCluster(String cluster) {
        this.rLock.lock();
        try {
            EvictingQueue events = (EvictingQueue)this.store.get(cluster);
            AbstractWanEvent[] abstractWanEventArray = events != null ? (AbstractWanEvent[])events.toArray((Object[])new AbstractWanEvent[0]) : new AbstractWanEvent[]{};
            return abstractWanEventArray;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

