/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.validation.metrics;

import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.controller.validation.metrics.Metric;
import com.hazelcast.webmonitor.controller.validation.metrics.MetricValidator;
import com.hazelcast.webmonitor.utils.StringUtil;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MetricValidator
implements ConstraintValidator<Metric, MetricDTO> {
    public void initialize(Metric constraintAnnotation) {
    }

    public boolean isValid(MetricDTO dto, ConstraintValidatorContext constraintContext) {
        if (!this.supportedAggregateBy(dto) || !this.supportedAggregate(dto)) {
            return false;
        }
        if (this.forMember(dto) && this.forClient(dto)) {
            return false;
        }
        if (!this.forMember(dto) && !this.forClient(dto)) {
            if (dto.getAggregate() == MetricDTO.Aggregate.DIFF_PER_SEC) {
                return false;
            }
            return dto.getAggregate() != null && dto.getAggregateBy() != null;
        }
        if (dto.getAggregate() == MetricDTO.Aggregate.DIFF_PER_SEC) {
            return dto.getAggregateBy() == null;
        }
        return dto.getAggregateBy() == null && dto.getAggregate() == null;
    }

    private boolean supportedAggregateBy(MetricDTO dto) {
        return dto.getAggregateBy() == null || dto.getAggregateBy() == MetricDTO.AggregateBy.MEMBERS;
    }

    private boolean supportedAggregate(MetricDTO dto) {
        if (dto.getAggregate() == null) {
            return true;
        }
        switch (1.$SwitchMap$com$hazelcast$webmonitor$controller$dto$metrics$MetricDTO$Aggregate[dto.getAggregate().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private boolean forMember(MetricDTO dto) {
        return !StringUtil.isNullOrEmptyAfterTrim((String)dto.getMember());
    }

    private boolean forClient(MetricDTO dto) {
        return !StringUtil.isNullOrEmptyAfterTrim((String)dto.getClient());
    }
}

