/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.UserCredentialsDTO;
import com.hazelcast.webmonitor.controller.dto.UserInfoDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.sql.UserCredentialsModel;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class UserController
extends BaseInternalController {
    private final AuthenticationManagerImpl authenticationManagerImpl;
    private final UserDAO userDAO;

    public UserController(StateManager stateManager, AuthenticationManagerImpl authenticationManagerImpl, UserDAO userDAO, AuditLogService auditService) {
        super(stateManager, auditService);
        this.authenticationManagerImpl = authenticationManagerImpl;
        this.userDAO = userDAO;
    }

    @GetMapping(path={"/self"})
    public UserInfoDTO self() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String username = authentication.getName();
        List roles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        Optional lastLoginTime = this.userDAO.getLastLoginTime(authentication.getName());
        long lastLoginTimeMillis = lastLoginTime.map(time -> time.toInstant().toEpochMilli()).orElse(0L);
        return new UserInfoDTO(username, roles, lastLoginTimeMillis);
    }

    @GetMapping(path={"/users/{username}"})
    @Secured(value={"ROLE_ADMIN"})
    public UserCredentialsDTO getUser(@PathVariable(name="username") String username) {
        UserCredentialsModel user = this.authenticationManagerImpl.getUser(username);
        return UserCredentialsDTO.fromModel((UserCredentialsModel)user);
    }

    @GetMapping(path={"/users"})
    @Secured(value={"ROLE_ADMIN"})
    public List<UserCredentialsDTO> getUsers() {
        return this.authenticationManagerImpl.getUsers().stream().map(UserCredentialsDTO::fromModel).collect(Collectors.toList());
    }

    @PostMapping(path={"/users"})
    @Secured(value={"ROLE_ADMIN"})
    public void createUser(@RequestParam String username, @RequestParam String password, @RequestParam String role) {
        this.authenticationManagerImpl.createUser(username, password, role);
        this.auditService.log(this.configLogBuilder("MC-0003 [Config]", "Create User in Default Security Provider").parameter("createdUsername", (Object)username).parameter("createdRole", (Object)role).build());
    }

    @PostMapping(path={"/users/{username}"})
    @Secured(value={"ROLE_ADMIN"})
    public void updateUser(@PathVariable String username, @RequestParam String role) {
        this.authenticationManagerImpl.updateUser(username, role);
        this.auditService.log(this.configLogBuilder("MC-0004 [Config]", "Update User in Default Security Provider").parameter("updatedUsername", (Object)username).parameter("updatedRole", (Object)role).build());
    }

    @PostMapping(path={"/users/{username}/actions/changePassword"})
    @Secured(value={"ROLE_ADMIN"})
    public void changePassword(@PathVariable String username, @RequestParam String ownPassword, @RequestParam String newPassword) {
        if (!this.authenticationManagerImpl.checkPassword(this.currentUser(), ownPassword)) {
            throw new SecurityConfigApiException("Your password is not correct.");
        }
        this.authenticationManagerImpl.changePassword(username, newPassword);
        this.auditService.log(this.configLogBuilder("MC-0005 [Config]", "Change User Password in Default Security Provider").parameter("updatedUsername", (Object)username).build());
    }

    @PostMapping(path={"/users/{username}/actions/delete"})
    @Secured(value={"ROLE_ADMIN"})
    public void deleteUser(@PathVariable String username, @RequestParam String ownPassword) {
        String loggedInUsername = this.currentUser();
        if (!this.authenticationManagerImpl.checkPassword(loggedInUsername, ownPassword)) {
            throw new SecurityConfigApiException("Your password is not correct.");
        }
        if (loggedInUsername != null && loggedInUsername.equals(username)) {
            throw new SecurityConfigApiException("You cannot delete the user you have logged in with.");
        }
        this.authenticationManagerImpl.deleteUser(username);
        this.auditService.log(this.configLogBuilder("MC-0006 [Config]", "Delete User in Default Security Provider").parameter("deletedUsername", (Object)username).build());
    }
}

