/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.coveo.saml.SamlClient;
import com.coveo.saml.SamlException;
import com.coveo.saml.SamlResponse;
import com.hazelcast.webmonitor.controller.dto.SamlFormDTO;
import com.hazelcast.webmonitor.security.CustomAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.InvalidSamlResponseException;
import com.hazelcast.webmonitor.security.UserHasNoRolesException;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToAuthoritiesMapper;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlSecurityProvider;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSAnyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Controller
public class SamlController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlController.class);
    private final AuthenticationManagerImpl authenticationManager;
    private final SpringTemplateEngine springTemplateEngine;
    private final CustomAuthenticationFailureHandler authenticationFailureHandler;

    @GetMapping(value={"/saml"})
    @ResponseBody
    public SamlFormDTO saml() throws SamlException {
        SamlClient client = this.getSamlClient();
        String encodedRequest = client.getSamlRequest();
        String idpUrl = client.getIdentityProviderUrl();
        return new SamlFormDTO(idpUrl, encodedRequest);
    }

    @GetMapping(value={"/saml/metadata"}, produces={"text/xml; charset=utf-8"})
    @ResponseBody
    public String samlMetadata() {
        Context context = new Context();
        context.setVariable("saml_postback_url", (Object)this.getSamlConfig().getPostBackUrl());
        context.setVariable("saml_entity_id", (Object)this.getSamlConfig().getRelyingPartyId());
        return this.springTemplateEngine.process("saml-sp-metadata-template", (IContext)context);
    }

    @PostMapping(value={"/saml/sso"}, produces={"text/html; charset=utf-8"})
    public void sso(@RequestParam(name="SAMLResponse") String encodedResponse, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        SamlResponse samlResponse;
        LOGGER.debug("Received SAML response: {}", (Object)encodedResponse);
        SamlClient client = this.getSamlClient();
        SamlConfig config = this.getSamlConfig();
        try {
            samlResponse = client.decodeAndValidateSamlResponse(encodedResponse, "POST");
        }
        catch (SamlException e) {
            InvalidSamlResponseException samlResponseException = new InvalidSamlResponseException(e);
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)samlResponseException);
            return;
        }
        String authenticatedUser = samlResponse.getNameID();
        Collection authorities = this.getAuthorities(samlResponse, config);
        if (authorities.isEmpty()) {
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)new UserHasNoRolesException());
            return;
        }
        LOGGER.debug("Authenticating user via SAML - username={}, authorities={}", (Object)authenticatedUser, (Object)authorities);
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)authenticatedUser, null, authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        response.sendRedirect(StringUtil.isNullOrEmptyAfterTrim((String)request.getContextPath()) ? "/" : request.getContextPath());
    }

    private Collection<? extends GrantedAuthority> getAuthorities(SamlResponse response, SamlConfig config) {
        Set values = response.getAssertion().getAttributeStatements().stream().flatMap(stmt -> stmt.getAttributes().stream()).filter(attribute -> config.getGroupAttribute().equalsIgnoreCase(attribute.getName())).flatMap(attribute -> attribute.getAttributeValues().stream()).map(arg_0 -> this.getAttributeValue(arg_0)).filter(Objects::nonNull).flatMap(s -> Arrays.stream(s.split(Pattern.quote(config.getGroupNameSeparator())))).collect(Collectors.toSet());
        LOGGER.debug("Values for the configured group attribute [{}] are: {}", (Object)config.getGroupAttribute(), values);
        return GroupsToAuthoritiesMapper.mapGroupsToAuthorities(values, (GroupsToRolesMappingConfig)config.getGroupsToRolesMappingConfig());
    }

    private SamlConfig getSamlConfig() {
        return this.getSamlSecurityProvider().readConfig();
    }

    private SamlClient getSamlClient() {
        return this.getSamlSecurityProvider().newSamlClient();
    }

    private SamlSecurityProvider getSamlSecurityProvider() {
        if (!this.authenticationManager.isSecurityProviderConfigured()) {
            throw new SecurityConfigApiException("Security provider needs to be configured for SAML authentication to work.");
        }
        if (!(this.authenticationManager.getCurrentSecurityProvider() instanceof SamlSecurityProvider)) {
            throw new SecurityConfigApiException("Current security provider needs to be SAML for SAML authentication to work.");
        }
        return (SamlSecurityProvider)this.authenticationManager.getCurrentSecurityProvider();
    }

    private String getAttributeValue(XMLObject attributeValue) {
        return attributeValue == null ? null : (attributeValue instanceof XSString ? this.getStringAttributeValue((XSString)attributeValue) : (attributeValue instanceof XSAnyImpl ? this.getAnyAttributeValue((XSAnyImpl)attributeValue) : attributeValue.toString()));
    }

    private String getStringAttributeValue(XSString attributeValue) {
        return attributeValue.getValue();
    }

    private String getAnyAttributeValue(XSAnyImpl attributeValue) {
        return attributeValue.getTextContent();
    }

    @ConstructorProperties(value={"authenticationManager", "springTemplateEngine", "authenticationFailureHandler"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SamlController(AuthenticationManagerImpl authenticationManager, SpringTemplateEngine springTemplateEngine, CustomAuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationManager = authenticationManager;
        this.springTemplateEngine = springTemplateEngine;
        this.authenticationFailureHandler = authenticationFailureHandler;
    }
}

