/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.QueueThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.DataStructureStatsService;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class QueueController
extends BaseInternalController {
    private final DataStructureStatsService statsService;
    private final OperationDispatcher operationDispatcher;

    public QueueController(DataStructureStatsService statsService, StateManager stateManager, OperationDispatcher operationDispatcher, AuditLogService auditService) {
        super(stateManager, auditService);
        this.statsService = statsService;
        this.operationDispatcher = operationDispatcher;
    }

    @GetMapping(value={"/clusters/{cluster}/queues/{queue}/throughputStats"})
    public List<QueueThroughputStatsDTO> getQueueThroughputStats(@PathVariable String cluster, @PathVariable String queue, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return this.statsService.getQueueThroughputStats(cluster, queue, time, interval);
    }

    @DeleteMapping(value={"/clusters/{cluster}/queues/{queue}/ageMetrics"})
    public void resetAgeStats(@PathVariable String cluster, @PathVariable String queue) {
        this.operationDispatcher.executeOnCluster(cluster, client -> client.resetQueueAgeMetrics(queue), exc -> "Failed to reset age-related metrics of queue " + queue);
    }
}

