/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.license.LicenseInfoDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoMasterMemberApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.LicenseDTO;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class LicenseController
extends BaseInternalController {
    private final LicenseManager licenseManager;

    @Autowired
    public LicenseController(StateManager stateManager, LicenseManager licenseManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.licenseManager = licenseManager;
    }

    @GetMapping(path={"/clusters/{cluster}/license"})
    public LicenseInfoDTO getClusterLicense(@PathVariable String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            throw new NoClusterApiException(cluster);
        }
        String master = Utils.getMaster((AllState)state);
        if (master == null) {
            throw new NoMasterMemberApiException(cluster);
        }
        LicenseDTO licenseDTO = ((MemberState)state.getMemberStates().get(master)).getNodeState().getLicenseDTO();
        if (licenseDTO == null) {
            return LicenseInfoDTO.notConfigured();
        }
        return new LicenseInfoDTO(licenseDTO);
    }

    @GetMapping(path={"/license"})
    public LicenseInfoDTO getMCLicense() {
        try {
            return new LicenseInfoDTO(this.licenseManager.getLicense(), this.licenseManager.isBuiltInLicense());
        }
        catch (InvalidLicenseException e) {
            return LicenseInfoDTO.notConfigured();
        }
    }

    @PostMapping(path={"/license"})
    @Secured(value={"ROLE_ADMIN"})
    public void updateMCLicense(@RequestParam String key) {
        this.licenseManager.persistLicenseKey(key);
        this.auditService.log(this.configLogBuilder("MC-0009 [Config]", "Configure MC License").build());
    }
}

