/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.healthcheck.AddIgnoreListEntryRequestDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.EventPublishingHealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreListEntryAlreadyExistsException;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class HealthCheckController
extends BaseInternalController {
    private final EventPublishingHealthCheckService service;

    public HealthCheckController(EventPublishingHealthCheckService service, StateManager stateManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.service = service;
    }

    @GetMapping(value={"/clusters/{cluster}/health"})
    @Secured(value={"ROLE_ADMIN"})
    public Collection<AnalysisOutcome> performHealthCheck(@PathVariable String cluster) {
        return this.service.analyze(cluster);
    }

    @PostMapping(value={"/clusters/{cluster}/health/ignoreList"})
    public ResponseEntity<Void> addIgnoreListEntry(@PathVariable(value="cluster") String cluster, @Valid @RequestBody AddIgnoreListEntryRequestDTO request, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        try {
            this.service.addIgnoreListEntry(cluster, request);
            return ResponseEntity.ok().build();
        }
        catch (IgnoreListEntryAlreadyExistsException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
        }
    }
}

