/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnDiagnosisService;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnectionDiagnosis;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/clusters/{cluster}/connectionDiagnosis"})
public class ClusterConnectionDiagnosisController
extends BaseInternalController {
    private final ConnDiagnosisService connDiagnosisService;

    public ClusterConnectionDiagnosisController(StateManager stateManager, AuditLogService auditService, ConnDiagnosisService connDiagnosisService) {
        super(stateManager, auditService);
        this.connDiagnosisService = connDiagnosisService;
    }

    @PostMapping
    public void initiateDiagnosis(@PathVariable String cluster) {
        this.connDiagnosisService.initiateDiagnosis(cluster);
    }

    @GetMapping
    public ConnectionDiagnosis get(@PathVariable String cluster) {
        ConnectionDiagnosis diagnosis = this.connDiagnosisService.getDiagnosis(cluster);
        if (diagnosis == null) {
            throw new NoResourceApiException("diagnosis for cluster " + cluster + " not found");
        }
        return diagnosis;
    }

    @DeleteMapping
    public void delete(@PathVariable String cluster) {
        if (this.connDiagnosisService.getDiagnosis(cluster) == null) {
            throw new NoResourceApiException("diagnosis for cluster " + cluster + " not found");
        }
        this.connDiagnosisService.deleteDiagnosis(cluster);
    }
}

