/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.CPMemberDTO;
import com.hazelcast.webmonitor.controller.dto.CPSubsystemStatusDTO;
import com.hazelcast.webmonitor.controller.dto.cp.AtomicLongStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPDataStructureListingDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSessionMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSubsystemMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CountDownLatchStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.FencedLockStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.SemaphoreStatsDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.CPInstanceType;
import com.hazelcast.webmonitor.service.CPStatsService;
import com.hazelcast.webmonitor.service.CPSubsystemManager;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class CPSubsystemController
extends BaseInternalController {
    private final CPSubsystemManager cpSubsystemManager;
    private final CPStatsService cpStatsService;

    @Autowired
    public CPSubsystemController(CPSubsystemManager cpSubsystemManager, StateManager stateManager, AuditLogService auditService, CPStatsService cpStatsService) {
        super(stateManager, auditService);
        this.cpSubsystemManager = cpSubsystemManager;
        this.cpStatsService = cpStatsService;
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/status"})
    public CPSubsystemStatusDTO getStatus(@PathVariable String cluster) {
        return this.cpSubsystemManager.getStatus(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/members"})
    public List<CPMemberDTO> getCPMembers(@PathVariable String cluster) {
        return this.cpSubsystemManager.getCPMembers(cluster).stream().map(m -> {
            String address = this.cpSubsystemManager.getCpMemberAddress(m.getCPUuid().toString());
            return new CPMemberDTO(m.getCPUuid().toString(), address);
        }).collect(Collectors.toList());
    }

    @PostMapping(path={"/clusters/{cluster}/cpSubsystem/promote"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void promoteToCPMember(@PathVariable String cluster, @RequestParam String member) {
        this.executeOperation(() -> this.cpSubsystemManager.promoteToCPMember(cluster, member), this.operationLogBuilder("MC-8001 [CP Subsystem]", "Promote Member to CP Subsystem").parameter("cluster", (Object)cluster).parameter("member", (Object)member));
    }

    @PostMapping(path={"/clusters/{cluster}/cpSubsystem/remove"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void removeCPMember(@PathVariable String cluster, @RequestParam UUID cpMemberUuid) {
        this.executeOperation(() -> this.cpSubsystemManager.removeCPMember(cluster, cpMemberUuid), this.operationLogBuilder("MC-8002 [CP Subsystem]", "Remove CP Member from CP Subsystem").parameter("cluster", (Object)cluster).parameter("cpMemberUuid", (Object)cpMemberUuid));
    }

    @PostMapping(path={"/clusters/{cluster}/cpSubsystem/reset"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void reset(@PathVariable String cluster) {
        this.executeOperation(() -> this.cpSubsystemManager.resetCPSubsystem(cluster), this.operationLogBuilder("MC-8003 [CP Subsystem]", "Restart CP Subsystem").parameter("cluster", (Object)cluster));
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/metrics/subsystem"})
    public List<CPSubsystemMetricsDTO> subsystemMetrics(@PathVariable String cluster) {
        return this.cpStatsService.subsystemMetrics(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/metrics/groups"})
    public List<CPGroupMetricsDTO> groupMetrics(@PathVariable String cluster) {
        return this.cpStatsService.groupMetrics(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/metrics/session"})
    public List<CPSessionMetricsDTO> sessionMetrics(@PathVariable String cluster) {
        return this.cpStatsService.sessionMetrics(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/atomiclongs"})
    public List<CPDataStructureListingDTO> atomicLongs(@PathVariable String cluster) {
        return this.cpStatsService.structsByType(cluster, CPInstanceType.ATOMIC_LONG);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/atomiclongs/{instanceName}/stats"})
    public AtomicLongStatsDTO atomiclongStats(@PathVariable String cluster, @PathVariable String instanceName, @RequestParam(defaultValue="0") long time) {
        return this.cpStatsService.getAtomicLongStats(cluster, instanceName, time);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/semaphores"})
    public List<CPDataStructureListingDTO> semaphores(@PathVariable String cluster) {
        return this.cpStatsService.structsByType(cluster, CPInstanceType.SEMAPHORE);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/semaphores/{instanceName}/stats"})
    public SemaphoreStatsDTO semaphoreStats(@PathVariable String cluster, @PathVariable String instanceName, @RequestParam(defaultValue="0") long time) {
        return this.cpStatsService.getSemaphoreStats(cluster, instanceName, time);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/atomicreferences"})
    public List<CPDataStructureListingDTO> atomicReferences(@PathVariable String cluster) {
        return this.cpStatsService.structsByType(cluster, CPInstanceType.ATOMIC_REFERENCE);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/fencedlocks"})
    public List<CPDataStructureListingDTO> fencedLocks(@PathVariable String cluster) {
        return this.cpStatsService.structsByType(cluster, CPInstanceType.FENCED_LOCK);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/fencedlocks/{instanceName}/stats"})
    public FencedLockStatsDTO fencedLockStats(@PathVariable String cluster, @PathVariable String instanceName, @RequestParam(defaultValue="0") long time) {
        return this.cpStatsService.getFencedLockStats(cluster, instanceName, time);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/countdownlatches"})
    public List<CPDataStructureListingDTO> countdownLatches(@PathVariable String cluster) {
        return this.cpStatsService.structsByType(cluster, CPInstanceType.COUNTDOWN_LATCH);
    }

    @GetMapping(path={"/clusters/{cluster}/cpSubsystem/countdownlatches/{instanceName}/stats"})
    public CountDownLatchStatsDTO countdownLatchStats(@PathVariable String cluster, @PathVariable String instanceName, @RequestParam(defaultValue="0") long time) {
        return this.cpStatsService.getCountdownLatchStats(cluster, instanceName, time);
    }
}

