/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.configreplacer;

import com.hazelcast.webmonitor.configreplacer.spi.ConfigReplacer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPbeReplacer
implements ConfigReplacer {
    static final String PROPERTY_CIPHER_ALGORITHM = "hazelcast.mc.configReplacer.prop.cipherAlgorithm";
    static final String PROPERTY_SECRET_KEY_FACTORY_ALGORITHM = "hazelcast.mc.configReplacer.prop.secretKeyFactoryAlgorithm";
    static final String PROPERTY_SECRET_KEY_ALGORITHM = "hazelcast.mc.configReplacer.prop.secretKeyAlgorithm";
    static final String PROPERTY_KEY_LENGTH_BITS = "hazelcast.mc.configReplacer.prop.keyLengthBits";
    static final String PROPERTY_SALT_LENGTH_BYTES = "hazelcast.mc.configReplacer.prop.saltLengthBytes";
    static final String PROPERTY_SECURITY_PROVIDER = "hazelcast.mc.configReplacer.prop.securityProvider";
    static final String DEFAULT_CIPHER_ALGORITHM = "AES";
    static final String DEFAULT_SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPbeReplacer.class);
    private final SecureRandom secureRandom = new SecureRandom();
    private String cipherAlgorithm;
    private String secretKeyFactoryAlgorithm;
    private String secretKeyAlgorithm;
    private String securityProvider;
    private int keyLengthBits;
    private int saltLengthBytes;

    public void init(Properties properties) {
        this.securityProvider = properties.getProperty(PROPERTY_SECURITY_PROVIDER);
        this.cipherAlgorithm = properties.getProperty(PROPERTY_CIPHER_ALGORITHM, DEFAULT_CIPHER_ALGORITHM);
        this.secretKeyFactoryAlgorithm = properties.getProperty(PROPERTY_SECRET_KEY_FACTORY_ALGORITHM, DEFAULT_SECRET_KEY_FACTORY_ALGORITHM);
        this.secretKeyAlgorithm = properties.getProperty(PROPERTY_SECRET_KEY_ALGORITHM, DEFAULT_CIPHER_ALGORITHM);
        this.keyLengthBits = Integer.parseInt(properties.getProperty(PROPERTY_KEY_LENGTH_BITS, "128"));
        this.saltLengthBytes = Integer.parseInt(properties.getProperty(PROPERTY_SALT_LENGTH_BYTES, "8"));
        if (this.keyLengthBits <= 0) {
            throw new IllegalArgumentException("Key length has to be positive number");
        }
        if (this.saltLengthBytes <= 0) {
            throw new IllegalArgumentException("Salt length has to be positive number");
        }
    }

    protected abstract char[] getPassword() throws Exception;

    public String getReplacement(String variable) {
        try {
            return this.decrypt(variable);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to decrypt variable " + variable, (Throwable)e);
            return null;
        }
    }

    String encrypt(String secretStr, int iterations) throws Exception {
        byte[] salt = new byte[this.saltLengthBytes];
        this.secureRandom.nextBytes(salt);
        byte[] encryptedVal = this.transform(1, secretStr.getBytes(StandardCharsets.UTF_8), salt, iterations);
        return new String(Base64.getEncoder().encode(salt), StandardCharsets.UTF_8) + ":" + iterations + ":" + new String(Base64.getEncoder().encode(encryptedVal), StandardCharsets.UTF_8);
    }

    String decrypt(String encryptedStr) throws Exception {
        String[] split = encryptedStr.split(":");
        if (split.length != 3) {
            throw new IllegalArgumentException("Wrong format of the encrypted variable (" + encryptedStr + ")");
        }
        byte[] salt = Base64.getDecoder().decode(split[0].getBytes(StandardCharsets.UTF_8));
        if (salt.length != this.saltLengthBytes) {
            throw new IllegalArgumentException("Salt length doesn't match.");
        }
        int iterations = Integer.parseInt(split[1]);
        byte[] encryptedVal = Base64.getDecoder().decode(split[2].getBytes(StandardCharsets.UTF_8));
        return new String(this.transform(2, encryptedVal, salt, iterations), StandardCharsets.UTF_8);
    }

    private byte[] transform(int cryptMode, byte[] value, byte[] salt, int iterations) throws Exception {
        if (iterations <= 0) {
            throw new IllegalArgumentException("Count of iterations has to be positive number.");
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.secretKeyFactoryAlgorithm);
        char[] password = this.getPassword();
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Empty password is not supported");
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password, salt, iterations, this.keyLengthBits);
        byte[] tmpKey = factory.generateSecret(pbeKeySpec).getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(tmpKey, this.secretKeyAlgorithm);
        Cipher cipher = this.securityProvider == null ? Cipher.getInstance(this.cipherAlgorithm) : Cipher.getInstance(this.cipherAlgorithm, this.securityProvider);
        cipher.init(cryptMode, secretKeySpec);
        return cipher.doFinal(value);
    }
}

