/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties.validation;

import com.hazelcast.webmonitor.config.properties.validation.DataSizeBetween;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

public class DataSizeBetweenValidator
implements ConstraintValidator<DataSizeBetween, DataSize> {
    private DataSize dataSizeMin;
    private DataSize dataSizeMax;

    public void initialize(DataSizeBetween dataSizeBetween) {
        this.dataSizeMin = DataSize.of((long)dataSizeBetween.min(), (DataUnit)dataSizeBetween.unit());
        this.dataSizeMax = DataSize.of((long)dataSizeBetween.max(), (DataUnit)dataSizeBetween.unit());
    }

    public boolean isValid(DataSize value, ConstraintValidatorContext context) {
        return this.dataSizeMin.compareTo(value) <= 0 && this.dataSizeMax.compareTo(value) >= 0;
    }
}

