/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildInfo {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private static final String PROPERTIES_RESOURCE = "/mc.properties";
    private static String fullVersion;
    private static byte majorVersion;
    private static String hazelcastClientVersion;
    private static String jettyVersion;
    private static String revision;
    private static String buildTimestamp;

    private BuildInfo() {
    }

    public static byte getMajorVersion() {
        return majorVersion;
    }

    public static String getFullVersion() {
        return fullVersion;
    }

    public static String getVersionForDocs() {
        Version version = Version.of((String)fullVersion);
        return version.toShortFormat() + (version.getQualifier() == null ? "" : version.getQualifier());
    }

    public static String getJettyVersion() {
        return jettyVersion;
    }

    public static String getHazelcastClientVersion() {
        return hazelcastClientVersion;
    }

    public static String getRevision() {
        return revision;
    }

    public static String getBuildTimestamp() {
        return buildTimestamp;
    }

    static {
        Properties properties = new Properties();
        try (InputStream propertiesStream = BuildInfo.class.getResourceAsStream(PROPERTIES_RESOURCE);){
            if (propertiesStream == null) {
                throw new IOException(String.format("Could not find %s", PROPERTIES_RESOURCE));
            }
            properties.load(propertiesStream);
            fullVersion = properties.getProperty("mc.version", "invalid");
            majorVersion = Byte.parseByte(String.valueOf(fullVersion.charAt(0)));
            revision = properties.getProperty("revision");
            buildTimestamp = properties.getProperty("build");
            hazelcastClientVersion = BuildInfoProvider.getBuildInfo().getVersion();
            jettyVersion = properties.getProperty("jetty.version");
        }
        catch (Exception e) {
            log.error("Cannot load BuildInfo!", (Throwable)e);
        }
    }
}

