/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.webmonitor.config.ResponseURLHeaderAddingFilter;
import com.hazelcast.webmonitor.config.UrlPathHelperNonDecoding;
import com.hazelcast.webmonitor.networking.URLFactory;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.CacheControl;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.CssLinkResourceTransformer;
import org.springframework.web.servlet.resource.EncodedResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import org.springframework.web.util.UrlPathHelper;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;

@EnableWebMvc
@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
public class WebConfig
implements WebMvcConfigurer {
    private static final int DAYS_IN_A_YEAR = 365;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/swagger-ui/", "classpath:/META-INF/resources/webjars/swagger-ui-dist/4.14.0/"});
        registry.addResourceHandler(new String[]{"/openapi/**"}).addResourceLocations(new String[]{"classpath:/openapi/"});
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"classpath:/static/images/"});
        registry.addResourceHandler(new String[]{"/font/**"}).addResourceLocations(new String[]{"classpath:/static/font/"});
        registry.addResourceHandler(new String[]{"/javascripts/**"}).addResourceLocations(new String[]{"classpath:/static/javascripts/"}).setCacheControl(CacheControl.maxAge((long)365L, (TimeUnit)TimeUnit.DAYS)).resourceChain(false).addResolver((ResourceResolver)new EncodedResourceResolver()).addResolver((ResourceResolver)new VersionResourceResolver().addContentVersionStrategy(new String[]{"/**"}));
        registry.addResourceHandler(new String[]{"/stylesheets/**"}).addResourceLocations(new String[]{"classpath:/static/stylesheets/"}).setCacheControl(CacheControl.maxAge((long)365L, (TimeUnit)TimeUnit.DAYS)).resourceChain(false).addResolver((ResourceResolver)new EncodedResourceResolver()).addResolver((ResourceResolver)new VersionResourceResolver().addContentVersionStrategy(new String[]{"/**"})).addTransformer((ResourceTransformer)new CssLinkResourceTransformer());
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/favicon.ico"});
        registry.setOrder(Integer.MIN_VALUE);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ResponseURLHeaderAddingFilter()).addPathPatterns(new String[]{"/**"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(this.jacksonObjectMapper());
        jacksonConverter.setDefaultCharset(StandardCharsets.UTF_8);
        converters.add((HttpMessageConverter<?>)jacksonConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUrlPathHelper((UrlPathHelper)new UrlPathHelperNonDecoding());
    }

    @Bean
    public SpringResourceTemplateResolver xmlTemplateResolver() {
        SpringResourceTemplateResolver xmlTemplateResolver = new SpringResourceTemplateResolver();
        xmlTemplateResolver.setPrefix("classpath:/templates/");
        xmlTemplateResolver.setSuffix(".xml");
        xmlTemplateResolver.setTemplateMode(TemplateMode.XML);
        xmlTemplateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        xmlTemplateResolver.setCheckExistence(true);
        xmlTemplateResolver.setCacheable(false);
        xmlTemplateResolver.setOrder(Integer.valueOf(2));
        return xmlTemplateResolver;
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((GenericConverter)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Bean
    public ObjectMapper jacksonObjectMapper() {
        return SerializationUtil.OBJECT_MAPPER;
    }

    @Bean
    public URLFactory urlFactory(ServletContext context) {
        return new URLFactory(context.getContextPath());
    }
}

