/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import picocli.CommandLine;

class GroupsToRolesMappingOptions {
    @CommandLine.Option(names={"-ag", "--admin-groups"}, required=true, description={"Which group(s) should be granted admin role. Use ';' as a separator if multiple groups are provided."})
    private String adminGroups;
    @CommandLine.Option(names={"-rwg", "--read-write-groups"}, required=true, description={"Which group(s) should be granted read/write user role. Use ';' as a separator if multiple groups are provided."})
    private String readWriteUserGroups;
    @CommandLine.Option(names={"-rog", "--read-only-groups"}, required=true, description={"Which group(s) should be granted readonly user role. Use ';' as a separator if multiple groups are provided."})
    private String readonlyUserGroups;
    @CommandLine.Option(names={"-mog", "--metrics-only-groups"}, required=true, description={"Which group(s) should be granted metrics only role. Use ';' as a separator if multiple groups are provided."})
    private String metricsOnlyGroups;

    GroupsToRolesMappingOptions() {
    }

    String getAdminGroups() {
        return this.adminGroups;
    }

    String getReadWriteUserGroups() {
        return this.readWriteUserGroups;
    }

    String getReadonlyUserGroups() {
        return this.readonlyUserGroups;
    }

    String getMetricsOnlyGroups() {
        return this.metricsOnlyGroups;
    }

    public GroupsToRolesMappingConfig toConfig() {
        return GroupsToRolesMappingConfig.builder().adminGroup(this.adminGroups).userGroup(this.readWriteUserGroups).readonlyUserGroup(this.readonlyUserGroups).metricsOnlyGroup(this.metricsOnlyGroups).build();
    }
}

