/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.GroupsToRolesMappingOptions;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.PersistentOidcConfig;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configure OpenID Connect Security Provider. No Security Provider should be already configured when using this task. If you need to overwrite security provider configuration, use 'security reset' task first.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false, showDefaultValues=true)
public class ConfigureOidcTask
extends BaseCliTask {
    @CommandLine.Option(names={"-ci", "--client-id"}, required=true, description={"OpenID Connect client application ID."})
    private String clientID;
    @CommandLine.Option(names={"-cs", "--client-secret"}, required=true, description={"OpenID Connect client application secret."})
    private String clientSecret;
    @CommandLine.Option(names={"-aeu", "--authorization-endpoint"}, required=true, description={"Authorization endpoint of the OpenID Connect provider."})
    private String authorizationEndpoint;
    @CommandLine.Option(names={"-uieu", "--user-info-endpoint"}, required=true, description={"UserInfo endpoint of the OpenID Connect provider."})
    private String userInfoEndpoint;
    @CommandLine.Option(names={"-teu", "--token-endpoint"}, required=true, description={"Token endpoint of the OpenID Connect provider."})
    private String tokenEndpoint;
    @CommandLine.Option(names={"-jsu", "--jwk-set-endpoint"}, required=true, description={"JWK Set endpoint of the OpenID Connect provider."})
    private String jwkSetEndpoint;
    @CommandLine.Option(names={"-is", "--issuer"}, required=true, description={"Issuer identifier of the OpenID Connect provider. It is usually (but not always) a URL."})
    private String issuer;
    @CommandLine.Option(names={"-scp", "--scope"}, defaultValue="openid profile groups", description={"Scope identifier of the OpenID Connect provider."})
    private String scope;
    @CommandLine.Option(names={"-ru", "--redirect-url"}, required=true, description={"URL of the Hazelcast Management Center endpoint that will handle redirects from the OpenID Connect provider. Formed by appending '/oidc/auth' to the base URL of Hazelcast Management Center."})
    private String redirectURL;
    @CommandLine.Option(names={"-uicn", "--user-id-claim-name"}, defaultValue="preferred_username", description={"Name of the claim that contains the user's ID."})
    private String userIdClaimName;
    @CommandLine.Option(names={"-gcn", "--groups-claim-name"}, defaultValue="groups", description={"Name of the claim that contains the user's groups."})
    private String groupsClaimName;
    @CommandLine.Option(names={"-ja", "--jws-algorithm"}, defaultValue="RS256", description={"JWS algorithm to use."})
    private String jwsAlgorithm;
    @CommandLine.Option(names={"-uirhm", "--user-info-request-http-method"}, defaultValue="GET", description={"HTTP method to use for sending the UserInfo request. Either GET or POST."})
    private String userInfoRequestHttpMethod;
    @CommandLine.Option(names={"-sciitr", "--send-client-info-in-token-request"}, defaultValue="false", description={"Whether client id and client secret should be sent as token request parameters."})
    private boolean sendClientInfoInTokenRequest;
    @CommandLine.Mixin
    private GroupsToRolesMappingOptions groupsToRolesMappingOptions;

    ConfigureOidcTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        if (securityManager.getCurrentSecurityProviderName() != null) {
            throw new CliException("Security Provider is already configured. Use 'security reset' task first, if you want to set up new security provider.");
        }
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        PersistentOidcConfig persistentConfig = new PersistentOidcConfig(groupedSettingsDAO);
        persistentConfig.write((SecurityProviderConfig)this.oidcConfig());
        securityManager.setCurrentSecurityProviderName("OpenID Connect");
        this.printf("Successfully set up OpenID Connect security provider.%n", new Object[0]);
    }

    private OidcConfig oidcConfig() {
        return OidcConfig.builder().clientId(this.clientID).clientSecret(this.clientSecret).authorizationEndpoint(this.authorizationEndpoint).userInfoEndpoint(this.userInfoEndpoint).tokenEndpoint(this.tokenEndpoint).jwkSetEndpoint(this.jwkSetEndpoint).issuer(this.issuer).scope(this.scope).redirectURL(this.redirectURL).userIdClaimName(this.userIdClaimName).groupsClaimName(this.groupsClaimName).jwsAlgorithm(this.jwsAlgorithm).userInfoRequestHttpMethod(this.userInfoRequestHttpMethod).sendClientInfoInTokenRequest(this.sendClientInfoInTokenRequest).groupsToRolesMappingConfig(this.groupsToRolesMappingOptions.toConfig()).build();
    }
}

