/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.GroupsToRolesMappingOptions;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.jaas.JaasConfig;
import com.hazelcast.webmonitor.security.spi.impl.jaas.PersistentJaasConfig;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configure JAAS Security Provider. No Security Provider should be already configured when using this task. If you need to overwrite security provider configuration, use 'security reset' task first.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
public class ConfigureJaasTask
extends BaseCliTask {
    @CommandLine.Option(names={"-lmc", "--login-module-class"}, required=true, description={"Class that implements javax.security.auth.spi.LoginModule that will be used to authorize users."})
    private String loginModuleClass;
    @CommandLine.Mixin
    private GroupsToRolesMappingOptions groupsToRolesMappingOptions;

    ConfigureJaasTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        if (securityManager.getCurrentSecurityProviderName() != null) {
            throw new CliException("Security Provider is already configured. Use 'security reset' task first, if you want to set up new security provider.");
        }
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        PersistentJaasConfig persistentConfig = new PersistentJaasConfig(groupedSettingsDAO);
        persistentConfig.write((SecurityProviderConfig)this.jaasConfig());
        securityManager.setCurrentSecurityProviderName("JAAS");
        this.printf("Successfully set up JAAS security provider.%n", new Object[0]);
    }

    private JaasConfig jaasConfig() {
        return JaasConfig.builder().loginModuleClass(this.loginModuleClass).groupsToRolesMappingConfig(this.groupsToRolesMappingOptions.toConfig()).build();
    }
}

