/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.auditlog.AuditLogConfig;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.config.SqlDbConfig;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import javax.sql.DataSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

abstract class BaseCliTask
implements Runnable {
    @CommandLine.Mixin
    protected HomeDirectoryOption homeDirOption;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Enable full logging output. Use this option to see full stack traces."}, order=1)
    private boolean verbose;
    @CommandLine.Option(names={"-l", "--lenient"}, description={"Exit with 0 when trying to add an object that already exists (fail silently)"}, arity="0..1")
    private boolean lenient;
    private final PrintWriter out;
    protected final ConfigurableEnvironment environment;
    protected final AuditLogService auditService;
    private HikariDataSource dataSource;
    private Jdbi jdbi;

    BaseCliTask(PrintWriter out, ConfigurableEnvironment environment) {
        this.out = out;
        this.environment = environment;
        boolean isAuditLogEnabled = (Boolean)environment.getProperty("hazelcast.mc.auditlog.enabled", Boolean.class, (Object)false);
        this.auditService = AuditLogConfig.auditLogService((boolean)isAuditLogEnabled);
    }

    @Override
    public void run() {
        this.configureLogging();
        try {
            this.execute();
        }
        finally {
            this.shutdown();
        }
    }

    public abstract void execute();

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    Jdbi initJdbi() {
        if (this.jdbi == null) {
            boolean skipLocking = (Boolean)this.environment.getProperty("hazelcast.mc.lock.skip", Boolean.class, (Object)false);
            HomeDirectoryProvider homeDirectoryProvider = this.homeDirOption.initProvider(this.environment, skipLocking);
            SqlDbConfig sqlDbConfig = new SqlDbConfig(skipLocking);
            this.dataSource = sqlDbConfig.dataSource(homeDirectoryProvider);
            this.jdbi = sqlDbConfig.jdbi((DataSource)this.dataSource);
        }
        return this.jdbi;
    }

    protected void shutdown() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    private void configureLogging() {
        Level logLevel = Level.WARN;
        if (this.verbose) {
            this.println("Verbose mode is on, setting logging level to INFO.");
            logLevel = Level.INFO;
        }
        Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)logLevel);
    }

    protected AuditableEvent.AuditableEventBuilder logBuilder(String eventId, String message) {
        return AuditableEvent.builder().typeId(eventId).message(message).parameter("username", (Object)"admin");
    }

    protected void printf(String format, Object ... objects) {
        this.out.printf(format, objects);
    }

    protected void println(String msg) {
        this.out.println(msg);
    }
}

