/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class DiagnosticsTool {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsTool.class);
    private static final String SCRIPT_FILE_NAME = "diagnostics.sh";
    private final Path rootDir;
    private final MCConfigurationProperties mcProperties;

    public DiagnosticsTool(HomeDirectoryProvider homeDir, MCConfigurationProperties mcProperties) {
        this.rootDir = homeDir.get().toAbsolutePath().resolve("diagnostics");
        File rootDirFile = this.rootDir.toFile();
        if (!rootDirFile.mkdir()) {
            if (rootDirFile.exists()) {
                log.warn("Please archive or delete the {} directory before starting Management Center with diagnostics enabled.", (Object)this.rootDir);
                throw new IllegalStateException("Directory " + this.rootDir + " already exists");
            }
            throw new IllegalStateException("Failed to create directory " + this.rootDir);
        }
        this.mcProperties = mcProperties;
    }

    @PostConstruct
    @Async
    public void start() {
        ForkJoinPool.commonPool().execute(() -> {
            try {
                String scheme;
                int port;
                this.extractCrawlerScript();
                int pid = this.getMCProcessId();
                if (this.mcProperties.getTls().isEnabled()) {
                    port = this.mcProperties.getHttpsPort();
                    scheme = "https";
                } else {
                    port = this.mcProperties.getHttpPort();
                    scheme = "http";
                }
                String mcUrl = scheme + "://localhost:" + port;
                Path outputFile = this.rootDir.resolve("diagnostics.out");
                log.info("working directory: {}", (Object)this.rootDir);
                log.info("running command ./{} {} {} > {}", new Object[]{SCRIPT_FILE_NAME, mcUrl, pid, outputFile});
                Process process = new ProcessBuilder(new String[0]).directory(this.rootDir.toFile()).command("./diagnostics.sh", mcUrl, String.valueOf(pid)).redirectOutput(outputFile.toFile()).start();
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    log.warn("The diagnostics script exited with {}. Please look into {}.", (Object)exitCode, (Object)outputFile);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private int getMCProcessId() {
        try {
            Class<?> clazz = Class.forName("java.lang.ProcessHandle");
            Object current = clazz.getMethod("current", new Class[0]).invoke(clazz, new Object[0]);
            Object pid = clazz.getMethod("pid", new Class[0]).invoke(current, new Object[0]);
            return (Integer)pid;
        }
        catch (ReflectiveOperationException e) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                Field jvm = runtime.getClass().getDeclaredField("jvm");
                jvm.setAccessible(true);
                Object mgmt = jvm.get(runtime);
                Method pidMethod = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
                pidMethod.setAccessible(true);
                return (Integer)pidMethod.invoke(mgmt, new Object[0]);
            }
            catch (ReflectiveOperationException e2) {
                return 0;
            }
        }
    }

    private void extractCrawlerScript() throws IOException {
        InputStream scriptResource = this.getClass().getResourceAsStream("/diagnostics.sh");
        List lines = IOUtils.readLines((InputStream)scriptResource, (Charset)StandardCharsets.UTF_8);
        Path scriptPath = this.rootDir.resolve(SCRIPT_FILE_NAME);
        File scriptFile = scriptPath.toFile();
        if (!scriptFile.createNewFile()) {
            throw new IllegalStateException("Failed to create file " + scriptPath);
        }
        try (FileOutputStream outputStream = new FileOutputStream(scriptFile);){
            IOUtils.writeLines((Collection)lines, (String)System.lineSeparator(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            if (!scriptFile.setExecutable(true)) {
                throw new IllegalStateException("Failed to make file executable: " + scriptPath);
            }
        }
    }
}

