/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyRules {
    private final Set<String> required = new HashSet<String>();
    private final Map<String, String> excludes = new HashMap<String, String>();
    private final Map<String, String> includes = new HashMap<String, String>();

    public PropertyRules required(String property) {
        this.required.add(property);
        return this;
    }

    public PropertyRules exclusive(String one, String other) {
        this.excludes.put(one, other);
        return this;
    }

    public PropertyRules inclusive(String one, String other) {
        this.includes.put(one, other);
        return this;
    }

    public void check(Properties properties) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String string : this.required) {
            if (properties.containsKey(string)) continue;
            errors.add(string + " must be specified");
        }
        for (Map.Entry entry : this.excludes.entrySet()) {
            if (!properties.containsKey(entry.getKey()) || !properties.containsKey(entry.getValue())) continue;
            errors.add((String)entry.getKey() + " and " + (String)entry.getValue() + " are mutually exclusive");
        }
        for (Map.Entry entry : this.includes.entrySet()) {
            if (!properties.containsKey(entry.getKey()) || properties.containsKey(entry.getValue())) continue;
            errors.add((String)entry.getKey() + " requires " + (String)entry.getValue() + " to be set too");
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException(String.join((CharSequence)", ", errors));
        }
    }
}

