/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import com.hazelcast.jet.cdc.impl.CdcSourceP;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class DebeziumConfig {
    private final Properties properties = new Properties();

    public DebeziumConfig(@Nonnull String name, @Nonnull String connectorClass) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(connectorClass, "connectorClass");
        this.properties.put("name", name);
        this.properties.put("connector.class", connectorClass);
        this.properties.put("database.history", CdcSourceP.DatabaseHistoryImpl.class.getName());
        this.properties.put("tombstones.on.delete", "false");
    }

    public void setProperty(String key, Object value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.properties.put(key, value);
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, (Object)value);
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setProperty(String key, long value) {
        this.setProperty(key, Long.toString(value));
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setProperty(String key, String ... values) {
        Objects.requireNonNull(values, "values");
        for (int i = 0; i < values.length; ++i) {
            Objects.requireNonNull(values[i], "values[" + i + "]");
        }
        this.setProperty(key, String.join((CharSequence)",", values));
    }

    public Properties toProperties() {
        return this.properties;
    }
}

