/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.retry.RetryStrategies;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.jet.retry.impl.RetryTracker;
import com.hazelcast.logging.ILogger;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.HistoryRecord;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.apache.kafka.connect.storage.OffsetStorageReader;

public abstract class CdcSourceP<T>
extends AbstractProcessor {
    public static final String NAME_PROPERTY = "name";
    public static final String CONNECTOR_CLASS_PROPERTY = "connector.class";
    public static final String SEQUENCE_EXTRACTOR_CLASS_PROPERTY = "sequence.extractor.class";
    public static final String RECONNECT_BEHAVIOR_PROPERTY = "reconnect.behavior";
    public static final String COMMIT_PERIOD_MILLIS_PROPERTY = "commit.period";
    public static final String RECONNECT_RESET_STATE_PROPERTY = "reconnect.reset.state";
    public static final RetryStrategy DEFAULT_RECONNECT_BEHAVIOR = RetryStrategies.never();
    public static final long DEFAULT_COMMIT_PERIOD_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final BroadcastKey<String> SNAPSHOT_KEY = BroadcastKey.broadcastKey((Object)"snap");
    private static final ThreadLocal<List<byte[]>> THREAD_LOCAL_HISTORY = new ThreadLocal();
    private static final String TIMESTAMP_MS_FIELD_NAME = "ts_ms";
    @Nonnull
    private final Properties properties;
    @Nonnull
    private final EventTimeMapper<? super T> eventTimeMapper;
    private SourceConnector connector;
    private Map<String, String> taskConfig;
    private SourceTask task;
    private State state = new State();
    private RetryTracker reconnectTracker;
    private boolean clearStateOnReconnect;
    private Traverser<Object> traverser = Traversers.empty();
    private Traverser<Map.Entry<BroadcastKey<String>, State>> snapshotTraverser;
    private boolean snapshotting;
    private long lastCommitTime;
    private long commitPeriod;
    private boolean snapshotInProgress;
    private ILogger logger;

    public CdcSourceP(@Nonnull Properties properties, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.eventTimeMapper = new EventTimeMapper(Objects.requireNonNull(eventTimePolicy, "eventTimePolicy"));
        this.eventTimeMapper.addPartitions(1);
    }

    protected void init(@Nonnull Processor.Context context) {
        DriverManager.getDrivers();
        String name = CdcSourceP.getName(this.properties);
        this.logger = context.logger();
        RetryStrategy retryStrategy = CdcSourceP.getRetryStrategy(this.properties);
        CdcSourceP.log(this.logger, name, "retry strategy", retryStrategy);
        this.reconnectTracker = new RetryTracker(retryStrategy);
        boolean bl = this.snapshotting = !ProcessingGuarantee.NONE.equals((Object)context.processingGuarantee());
        if (!this.snapshotting) {
            this.commitPeriod = CdcSourceP.getCommitPeriod(this.properties);
            CdcSourceP.log(this.logger, name, "commit period", this.commitPeriod);
            if (this.commitPeriod > 0L) {
                this.lastCommitTime = System.nanoTime();
            }
        }
        this.clearStateOnReconnect = CdcSourceP.getClearStateOnReconnect(this.properties);
        CdcSourceP.log(this.logger, name, "clear state on reconnect", this.clearStateOnReconnect);
    }

    public boolean isCooperative() {
        return false;
    }

    public boolean complete() {
        if (!this.emitFromTraverser(this.traverser)) {
            return false;
        }
        if (this.reconnectTracker.needsToWait()) {
            return false;
        }
        if (!this.isConnectionUp()) {
            return false;
        }
        if (this.snapshotInProgress) {
            return false;
        }
        try {
            List<SourceRecord> records;
            long currentTime;
            if (!this.snapshotting && this.commitPeriod > 0L && (currentTime = System.nanoTime()) - this.lastCommitTime > this.commitPeriod) {
                this.task.commit();
                this.lastCommitTime = currentTime;
            }
            if ((records = this.task.poll()) == null || records.isEmpty()) {
                this.traverser = this.eventTimeMapper.flatMapIdle();
                this.emitFromTraverser(this.traverser);
                return false;
            }
            for (SourceRecord record2 : records) {
                Map<String, ?> partition = record2.sourcePartition();
                Map<String, ?> offset = record2.sourceOffset();
                this.state.setOffset(partition, offset);
                this.task.commitRecord(record2, null);
            }
            if (!this.snapshotting && this.commitPeriod == 0L) {
                this.task.commit();
            }
            this.traverser = Traversers.traverseIterable(records).flatMap(record -> {
                T t = this.map((SourceRecord)record);
                return t == null ? Traversers.empty() : this.eventTimeMapper.flatMapEvent(t, 0, CdcSourceP.extractTimestamp(record));
            });
            this.emitFromTraverser(this.traverser);
        }
        catch (InterruptedException ie) {
            this.logger.warning("Interrupted while waiting for data");
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException re) {
            this.reconnect(re);
        }
        return false;
    }

    @Nullable
    protected abstract T map(SourceRecord var1);

    private void reconnect(RuntimeException re) {
        if (this.reconnectTracker.shouldTryAgain()) {
            this.logger.warning("Connection to database lost, will attempt to reconnect and retry operations from scratch" + CdcSourceP.getCause(re), (Throwable)re);
            this.killConnection();
            this.reconnectTracker.reset();
            if (this.clearStateOnReconnect) {
                this.state = new State();
            }
        } else {
            throw this.shutDownAndThrow(new JetException("Failed to connect to database", ExceptionUtil.peel((Throwable)re)));
        }
    }

    private <Th extends Throwable> Th shutDownAndThrow(Th th) {
        this.killConnection();
        return th;
    }

    private boolean isConnectionUp() {
        try {
            if (this.connector == null) {
                this.connector = this.startNewConnector();
                this.taskConfig = this.connector.taskConfigs(1).get(0);
            }
            if (this.task == null) {
                this.task = this.startNewTask();
            }
            this.reconnectTracker.reset();
            return true;
        }
        catch (JetException je) {
            throw this.shutDownAndThrow(je);
        }
        catch (RuntimeException re) {
            this.handleConnectException(re);
            return false;
        }
    }

    private SourceConnector startNewConnector() {
        SourceConnector connector = (SourceConnector)CdcSourceP.newInstance(this.properties.getProperty(CONNECTOR_CLASS_PROPERTY), "connector");
        connector.initialize(new JetConnectorContext());
        connector.start(this.properties);
        return connector;
    }

    private SourceTask startNewTask() {
        this.logger.info("starting new task with config: " + this.taskConfig);
        SourceTask task = (SourceTask)CdcSourceP.newInstance(this.connector.taskClass().getName(), "task");
        task.initialize(new JetSourceTaskContext());
        THREAD_LOCAL_HISTORY.set(this.state.historyRecords);
        task.start(this.taskConfig);
        THREAD_LOCAL_HISTORY.remove();
        return task;
    }

    private void handleConnectException(RuntimeException ce) {
        this.reconnectTracker.attemptFailed();
        if (!this.reconnectTracker.shouldTryAgain()) {
            throw this.shutDownAndThrow(new JetException("Failed to connect to database", ExceptionUtil.peel((Throwable)ce)));
        }
        long waitTimeMs = this.reconnectTracker.getNextWaitTimeMs();
        this.logger.warning("Failed to initialize the connector task, retrying in " + waitTimeMs + "ms" + CdcSourceP.getCause(ce));
    }

    public boolean saveToSnapshot() {
        if (!this.emitFromTraverser(this.traverser)) {
            return false;
        }
        this.snapshotInProgress = true;
        if (this.snapshotTraverser == null) {
            this.snapshotTraverser = Traversers.singleton((Object)Util.entry(SNAPSHOT_KEY, (Object)this.state)).onFirstNull(() -> {
                this.snapshotTraverser = null;
                this.getLogger().finest("Finished saving snapshot.");
            });
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    public boolean snapshotCommitFinish(boolean success) {
        if (success && this.task != null) {
            try {
                this.task.commit();
            }
            catch (InterruptedException e) {
                this.logger.warning("Interrupted while committing");
                Thread.currentThread().interrupt();
            }
        }
        this.snapshotInProgress = false;
        return true;
    }

    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (!SNAPSHOT_KEY.equals(key)) {
            throw new RuntimeException("Unexpected key received from snapshot: " + key);
        }
        this.state = (State)value;
    }

    public void close() {
        this.killConnection();
    }

    private void killConnection() {
        if (this.task != null) {
            this.task.stop();
            this.task = null;
        }
        if (this.connector != null) {
            this.connector.stop();
            this.connector = null;
        }
    }

    private static String getCause(Exception e) {
        StringBuilder sb = new StringBuilder();
        if (e.getMessage() != null) {
            sb.append(": ").append(e.getMessage());
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            sb.append(": ").append(e.getCause().getMessage());
        }
        return sb.toString();
    }

    protected static <T> T newInstance(String className, String type) throws JetException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JetException(String.format("%s class %s not found", type, className));
        }
        catch (InstantiationException e) {
            throw new JetException(String.format("%s class %s can't be instantiated", type, className));
        }
        catch (IllegalArgumentException | NoSuchMethodException e) {
            throw new JetException(String.format("%s class %s has no default constructor", type, className));
        }
        catch (IllegalAccessException e) {
            throw new JetException(String.format("Default constructor of %s class %s is not accessible", type, className));
        }
        catch (InvocationTargetException e) {
            throw new JetException(String.format("%s class %s failed on construction: %s", type, className, e.getMessage()));
        }
    }

    private static String getName(Properties properties) {
        return (String)properties.get(NAME_PROPERTY);
    }

    private static RetryStrategy getRetryStrategy(Properties properties) {
        RetryStrategy strategy = (RetryStrategy)properties.get(RECONNECT_BEHAVIOR_PROPERTY);
        return strategy == null ? DEFAULT_RECONNECT_BEHAVIOR : strategy;
    }

    private static long getCommitPeriod(Properties properties) {
        String periodString = (String)properties.get(COMMIT_PERIOD_MILLIS_PROPERTY);
        long periodMillis = periodString == null ? DEFAULT_COMMIT_PERIOD_MS : Long.parseLong(periodString);
        return TimeUnit.MILLISECONDS.toNanos(periodMillis);
    }

    private static boolean getClearStateOnReconnect(Properties properties) {
        String s = (String)properties.get(RECONNECT_RESET_STATE_PROPERTY);
        return Boolean.parseBoolean(s);
    }

    private static void log(ILogger logger, String name, String property, Object value) {
        if (logger.isInfoEnabled()) {
            logger.info(name + " has '" + property + "' set to '" + value + '\'');
        }
    }

    private static long extractTimestamp(SourceRecord sourceRecord) {
        boolean noSourceTsMs;
        Schema valueSchema = sourceRecord.valueSchema();
        boolean noValueTsMs = valueSchema.field(TIMESTAMP_MS_FIELD_NAME) == null;
        boolean bl = noSourceTsMs = valueSchema.field("source").schema().field(TIMESTAMP_MS_FIELD_NAME) == null;
        if (noValueTsMs && noSourceTsMs) {
            return Long.MIN_VALUE;
        }
        Struct valueStruct = (Struct)sourceRecord.value();
        Long timestamp = noValueTsMs ? valueStruct.getStruct("source").getInt64(TIMESTAMP_MS_FIELD_NAME) : valueStruct.getInt64(TIMESTAMP_MS_FIELD_NAME);
        return timestamp == null ? Long.MIN_VALUE : timestamp;
    }

    static /* synthetic */ ThreadLocal access$600() {
        return THREAD_LOCAL_HISTORY;
    }

    public static class DatabaseHistoryImpl
    extends AbstractDatabaseHistory {
        private final List<byte[]> history = (List)Objects.requireNonNull(CdcSourceP.access$600().get());

        @Override
        protected void storeRecord(HistoryRecord record) throws DatabaseHistoryException {
            this.history.add(DocumentWriter.defaultWriter().writeAsBytes(record.document()));
        }

        @Override
        protected void recoverRecords(Consumer<HistoryRecord> consumer) {
            try {
                for (byte[] record : this.history) {
                    Document doc = DocumentReader.defaultReader().read(record);
                    consumer.accept(new HistoryRecord(doc));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean exists() {
            return this.history != null && !this.history.isEmpty();
        }

        @Override
        public boolean storageExists() {
            return this.history != null;
        }
    }

    public static final class State {
        private final Map<Map<String, ?>, Map<String, ?>> partitionsToOffset;
        private final List<byte[]> historyRecords;

        State() {
            this(new HashMap(), new CopyOnWriteArrayList<byte[]>());
        }

        State(Map<Map<String, ?>, Map<String, ?>> partitionsToOffset, CopyOnWriteArrayList<byte[]> historyRecords) {
            this.partitionsToOffset = partitionsToOffset;
            this.historyRecords = historyRecords;
        }

        public Map<String, ?> getOffset(Map<String, ?> partition) {
            return this.partitionsToOffset.get(partition);
        }

        public void setOffset(Map<String, ?> partition, Map<String, ?> offset) {
            this.partitionsToOffset.put(partition, offset);
        }

        Map<Map<String, ?>, Map<String, ?>> getPartitionsToOffset() {
            return this.partitionsToOffset;
        }

        List<byte[]> getHistoryRecords() {
            return this.historyRecords;
        }
    }

    private static class JetConnectorContext
    implements ConnectorContext {
        private JetConnectorContext() {
        }

        @Override
        public void requestTaskReconfiguration() {
        }

        @Override
        public void raiseError(Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private class SourceOffsetStorageReader
    implements OffsetStorageReader {
        private SourceOffsetStorageReader() {
        }

        public <V> Map<String, Object> offset(Map<String, V> partition) {
            return this.offsets((Collection<Map<String, V>>)Collections.singletonList(partition)).get(partition);
        }

        public <V> Map<Map<String, V>, Map<String, Object>> offsets(Collection<Map<String, V>> partitions) {
            HashMap map = new HashMap();
            for (Map<String, V> partition : partitions) {
                Map<String, ?> offset = CdcSourceP.this.state.getOffset(partition);
                map.put(partition, offset);
            }
            return map;
        }
    }

    private class JetSourceTaskContext
    implements SourceTaskContext {
        private JetSourceTaskContext() {
        }

        @Override
        public Map<String, String> configs() {
            return CdcSourceP.this.taskConfig;
        }

        @Override
        public OffsetStorageReader offsetStorageReader() {
            return new SourceOffsetStorageReader();
        }
    }
}

