/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.codec.ZstdDecompressorStream;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

class DirectZstd {
    DirectZstd() {
    }

    static CodecFactory.BytesCompressor createCompressor(Configuration conf, int pageSize) {
        return new ZstdCompressor(DirectZstd.getPool(conf), conf.getInt("parquet.compression.codec.zstd.level", 3), conf.getInt("parquet.compression.codec.zstd.workers", 0), pageSize);
    }

    static CodecFactory.BytesDecompressor createDecompressor(Configuration conf) {
        return new ZstdDecompressor(DirectZstd.getPool(conf));
    }

    private static BufferPool getPool(Configuration conf) {
        if (conf.getBoolean("parquet.compression.codec.zstd.bufferPool.enabled", true)) {
            return RecyclingBufferPool.INSTANCE;
        }
        return NoPool.INSTANCE;
    }

    private static class BytesInputProviderOutputStream
    extends ByteArrayOutputStream {
        BytesInputProviderOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        BytesInput getBytesInput() {
            return BytesInput.from(this.buf, 0, this.count);
        }
    }

    private static class ZstdDecompressor
    extends CodecFactory.BytesDecompressor {
        private final BufferPool pool;

        private ZstdDecompressor(BufferPool pool) {
            this.pool = pool;
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            try (ZstdDecompressorStream decompressorStream = new ZstdDecompressorStream(bytes.toInputStream(), this.pool);){
                BytesInput bytesInput = BytesInput.copy(BytesInput.from(decompressorStream, uncompressedSize));
                return bytesInput;
            }
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            Zstd.decompress(output, input);
        }

        @Override
        public void release() {
        }
    }

    private static class ZstdCompressor
    extends CodecFactory.BytesCompressor {
        private final BufferPool pool;
        private final int level;
        private final int workers;
        private final int pageSize;

        ZstdCompressor(BufferPool pool, int level, int workers, int pageSize) {
            this.pool = pool;
            this.level = level;
            this.workers = workers;
            this.pageSize = pageSize;
        }

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            BytesInputProviderOutputStream stream = new BytesInputProviderOutputStream(this.pageSize);
            try (ZstdOutputStream zstdStream = new ZstdOutputStream((OutputStream)stream, this.pool, this.level);){
                zstdStream.setWorkers(this.workers);
                bytes.writeAllTo(zstdStream);
            }
            return stream.getBytesInput();
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CompressionCodecName.ZSTD;
        }

        @Override
        public void release() {
        }
    }
}

