/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class FileEntry
implements Serializable {
    private static final long serialVersionUID = -550288489009777867L;
    @JsonProperty(value="s")
    private String source;
    @JsonProperty(value="d")
    private String dest;
    @JsonProperty(value="z")
    private long size;
    @JsonProperty(value="e")
    private String etag;

    private FileEntry() {
    }

    public FileEntry(String source, String dest, long size, String etag) {
        this.source = source;
        this.dest = dest;
        this.size = size;
        this.etag = etag;
    }

    public FileEntry(Path source, Path dest, long size, String etag) {
        this(AbstractManifestData.marshallPath(source), AbstractManifestData.marshallPath(dest), size, etag);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    @JsonIgnore
    public Path getSourcePath() {
        return AbstractManifestData.unmarshallPath(this.source);
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getDest() {
        return this.dest;
    }

    @JsonIgnore
    public Path getDestPath() {
        return AbstractManifestData.unmarshallPath(this.dest);
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public void validate() throws IOException {
        String s2 = this.toString();
        AbstractManifestData.verify(this.source != null && this.source.length() > 0, "Source is missing from " + s2, new Object[0]);
        AbstractManifestData.verify(this.dest != null && this.dest.length() > 0, "Source is missing from " + s2, new Object[0]);
        AbstractManifestData.verify(this.size >= 0L, "Invalid size in " + s2, new Object[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileOrDirEntry{");
        sb.append("source='").append(this.source).append('\'');
        sb.append(", dest='").append(this.dest).append('\'');
        sb.append(", size=").append(this.size);
        sb.append(", etag='").append(this.etag).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileEntry that = (FileEntry)o;
        return this.size == that.size && this.source.equals(that.source) && this.dest.equals(that.dest) && Objects.equals(this.etag, that.etag);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.dest);
    }
}

