/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Detachable;
import io.grpc.HasByteBuffer;
import io.grpc.KnownLength;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class ZeroCopyMessageMarshaller<T extends MessageLite>
implements MethodDescriptor.PrototypeMarshaller<T> {
    private Map<T, InputStream> unclosedStreams = Collections.synchronizedMap(new IdentityHashMap());
    private final Parser<T> parser;
    private final MethodDescriptor.PrototypeMarshaller<T> marshaller;

    ZeroCopyMessageMarshaller(T defaultInstance) {
        this.parser = defaultInstance.getParserForType();
        this.marshaller = (MethodDescriptor.PrototypeMarshaller)ProtoLiteUtils.marshaller(defaultInstance);
    }

    @Override
    public Class<T> getMessageClass() {
        return this.marshaller.getMessageClass();
    }

    @Override
    public T getMessagePrototype() {
        return (T)((MessageLite)this.marshaller.getMessagePrototype());
    }

    @Override
    public InputStream stream(T value) {
        return this.marshaller.stream(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T parse(InputStream stream) {
        try {
            if (!(stream instanceof KnownLength)) return (T)((MessageLite)this.marshaller.parse(stream));
            if (!(stream instanceof Detachable)) return (T)((MessageLite)this.marshaller.parse(stream));
            if (!(stream instanceof HasByteBuffer)) return (T)((MessageLite)this.marshaller.parse(stream));
            if (!((HasByteBuffer)((Object)stream)).byteBufferSupported()) return (T)((MessageLite)this.marshaller.parse(stream));
            int size = stream.available();
            try (InputStream detachedStream = ((Detachable)((Object)stream)).detach();){
                T message;
                detachedStream.mark(size);
                ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
                while (detachedStream.available() != 0) {
                    ByteBuffer buffer = ((HasByteBuffer)((Object)detachedStream)).getByteBuffer();
                    byteStrings.add(UnsafeByteOperations.unsafeWrap(buffer));
                    detachedStream.skip(buffer.remaining());
                }
                detachedStream.reset();
                CodedInputStream codedInputStream = ByteString.copyFrom(byteStrings).newCodedInput();
                codedInputStream.enableAliasing(true);
                codedInputStream.setSizeLimit(Integer.MAX_VALUE);
                try {
                    message = this.parseFrom(codedInputStream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
                this.unclosedStreams.put(message, detachedStream);
                detachedStream = null;
                T t2 = message;
                return t2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
        MessageLite message = (MessageLite)this.parser.parseFrom(stream);
        try {
            stream.checkLastTagWas(0);
            return (T)message;
        }
        catch (InvalidProtocolBufferException e) {
            e.setUnfinishedMessage(message);
            throw e;
        }
    }

    public InputStream popStream(T message) {
        return this.unclosedStreams.remove(message);
    }

    public List<InputStream> popAllStreams() {
        ArrayList<InputStream> streams = new ArrayList<InputStream>(this.unclosedStreams.values());
        this.unclosedStreams.clear();
        return streams;
    }
}

