/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl;

import com.hazelcast.com.amazonaws.services.kinesis.model.Shard;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.kinesis.impl.source.HashRange;
import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public final class KinesisUtil {
    private KinesisUtil() {
    }

    public static <T> T readResult(Future<T> future) throws Throwable {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JetException("Interrupted while waiting for results");
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public static boolean shardBelongsToRange(@Nonnull BigInteger startingHashKey, @Nonnull HashRange range) {
        return range.contains(startingHashKey);
    }

    public static boolean shardBelongsToRange(@Nonnull Shard shard, @Nonnull HashRange range) {
        BigInteger startingHashKey = new BigInteger(shard.getHashKeyRange().getStartingHashKey());
        return KinesisUtil.shardBelongsToRange(startingHashKey, range);
    }
}

