/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.amazonaws.services.kinesisanalytics.model.transform;

import com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.com.amazonaws.services.kinesisanalytics.model.S3Configuration;
import com.hazelcast.com.amazonaws.transform.JsonUnmarshallerContext;
import com.hazelcast.com.amazonaws.transform.Unmarshaller;

public class S3ConfigurationJsonUnmarshaller
implements Unmarshaller<S3Configuration, JsonUnmarshallerContext> {
    private static S3ConfigurationJsonUnmarshaller instance;

    @Override
    public S3Configuration unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Configuration s3Configuration = new S3Configuration();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    s3Configuration.setRoleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BucketARN", targetDepth)) {
                    context.nextToken();
                    s3Configuration.setBucketARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FileKey", targetDepth)) {
                    context.nextToken();
                    s3Configuration.setFileKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Configuration;
    }

    public static S3ConfigurationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ConfigurationJsonUnmarshaller();
        }
        return instance;
    }
}

