/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.snapshots.SnapshotsService;

public class RestoreService
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RestoreService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestoreService.class);
    public static final Setting<Boolean> REFRESH_REPO_UUID_ON_RESTORE_SETTING = Setting.boolSetting("snapshot.refresh_repo_uuid_on_restore", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private static final Set<String> UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", "index.history.uuid"));
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final IndexMetadataVerifier indexMetadataVerifier;
    private final MetadataDeleteIndexService metadataDeleteIndexService;
    private final ShardLimitValidator shardLimitValidator;
    private final ClusterSettings clusterSettings;
    private final SystemIndices systemIndices;
    private volatile boolean refreshRepositoryUuidOnRestore;
    private volatile boolean cleanupInProgress = false;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataDeleteIndexService metadataDeleteIndexService, IndexMetadataVerifier indexMetadataVerifier, ShardLimitValidator shardLimitValidator, SystemIndices systemIndices) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.indexMetadataVerifier = indexMetadataVerifier;
        this.metadataDeleteIndexService = metadataDeleteIndexService;
        if (DiscoveryNode.isMasterNode(clusterService.getSettings())) {
            clusterService.addStateApplier(this);
        }
        this.clusterSettings = clusterService.getClusterSettings();
        this.shardLimitValidator = shardLimitValidator;
        this.systemIndices = systemIndices;
        this.refreshRepositoryUuidOnRestore = REFRESH_REPO_UUID_ON_RESTORE_SETTING.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(REFRESH_REPO_UUID_ON_RESTORE_SETTING, this::setRefreshRepositoryUuidOnRestore);
    }

    public void restoreSnapshot(RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener) {
        this.restoreSnapshot(request, listener, (clusterState, builder) -> {});
    }

    public void restoreSnapshot(RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener, BiConsumer<ClusterState, Metadata.Builder> updater) {
        try {
            StepListener<Void> repositoryUuidRefreshListener = new StepListener<Void>();
            RestoreService.refreshRepositoryUuids(this.refreshRepositoryUuidOnRestore, this.repositoriesService, repositoryUuidRefreshListener);
            String repositoryName = request.repository();
            Repository repository = this.repositoriesService.repository(repositoryName);
            StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
            repository.getRepositoryData(repositoryDataListener);
            repositoryDataListener.whenComplete(repositoryData -> repositoryUuidRefreshListener.whenComplete(ignored -> {
                String snapshotName = request.snapshot();
                Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
                if (!matchingSnapshotId.isPresent()) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
                }
                SnapshotId snapshotId = matchingSnapshotId.get();
                if (request.snapshotUuid() != null && !request.snapshotUuid().equals(snapshotId.getUUID())) {
                    throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot UUID mismatch: expected [" + request.snapshotUuid() + "] but got [" + snapshotId.getUUID() + "]");
                }
                repository.getSnapshotInfo(snapshotId, ActionListener.wrap(snapshotInfo -> this.startRestore((SnapshotInfo)snapshotInfo, repository, request, (RepositoryData)repositoryData, updater, listener), listener::onFailure));
            }, listener::onFailure), listener::onFailure);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repository() + ":" + request.snapshot())), (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void startRestore(SnapshotInfo snapshotInfo, Repository repository, RestoreSnapshotRequest request, RepositoryData repositoryData, BiConsumer<ClusterState, Metadata.Builder> updater, ActionListener<RestoreCompletionResponse> listener) throws IOException {
        Metadata.Builder metadataBuilder;
        assert (Repository.assertSnapshotMetaThread());
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        String repositoryName = repository.getMetadata().name();
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        RestoreService.validateSnapshotRestorable(repositoryName, snapshotInfo);
        Metadata globalMetadata = null;
        if (request.includeGlobalState()) {
            globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
            metadataBuilder = Metadata.builder(globalMetadata);
        } else {
            metadataBuilder = Metadata.builder();
        }
        String[] indicesInRequest = request.indices();
        ArrayList<String> requestIndices = new ArrayList<String>(indicesInRequest.length);
        if (indicesInRequest.length == 0) {
            requestIndices.add("*");
        } else {
            Collections.addAll(requestIndices, indicesInRequest);
        }
        Map<String, java.util.List<String>> featureStatesToRestore = this.getFeatureStatesToRestore(request, snapshotInfo, snapshot);
        Set<String> featureStateIndices = featureStatesToRestore.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, SystemIndices.Feature> featureSet = this.systemIndices.getFeatures();
        Set featureStateDataStreams = featureStatesToRestore.keySet().stream().filter(featureName -> {
            if (featureSet.containsKey(featureName)) {
                return true;
            }
            logger.warn(() -> new ParameterizedMessage("Restoring snapshot[{}] skipping feature [{}] because it is not available in this cluster", (Object)snapshotInfo.snapshotId(), featureName));
            return false;
        }).map(name -> this.systemIndices.getFeatures().get(name)).flatMap(feature -> feature.getDataStreamDescriptors().stream()).map(SystemDataStreamDescriptor::getDataStreamName).collect(Collectors.toSet());
        Tuple<Map<String, DataStream>, Map<String, DataStreamAlias>> result = this.getDataStreamsToRestore(repository, snapshotId, snapshotInfo, globalMetadata, Stream.concat(requestIndices.stream(), featureStateDataStreams.stream()).collect(Collectors.toList()), request.includeAliases());
        Map<String, DataStream> dataStreamsToRestore = result.v1();
        Map<String, DataStreamAlias> dataStreamAliasesToRestore = result.v2();
        requestIndices.removeAll(dataStreamsToRestore.keySet());
        Set<String> dataStreamIndices = dataStreamsToRestore.values().stream().flatMap(ds -> ds.getIndices().stream()).map(Index::getName).collect(Collectors.toSet());
        requestIndices.addAll(dataStreamIndices);
        java.util.List<String> requestedIndicesInSnapshot = SnapshotUtils.filterIndices(snapshotInfo.indices(), requestIndices.toArray(new String[0]), request.indicesOptions());
        java.util.List<String> requestedIndicesIncludingSystem = Stream.concat(requestedIndicesInSnapshot.stream(), featureStateIndices.stream()).distinct().collect(Collectors.toList());
        HashSet<String> explicitlyRequestedSystemIndices = new HashSet<String>();
        for (IndexId indexId : repositoryData.resolveIndices(requestedIndicesIncludingSystem).values()) {
            IndexMetadata snapshotIndexMetaData = repository.getSnapshotIndexMetaData(repositoryData, snapshotId, indexId);
            if (snapshotIndexMetaData.isSystem() && requestedIndicesInSnapshot.contains(indexId.getName())) {
                explicitlyRequestedSystemIndices.add(indexId.getName());
            }
            metadataBuilder.put(snapshotIndexMetaData, false);
        }
        if (snapshotInfo.version().onOrAfter(SnapshotsService.FEATURE_STATES_VERSION) && !explicitlyRequestedSystemIndices.isEmpty()) {
            deprecationLogger.critical(DeprecationCategory.API, "restore-system-index-from-snapshot", "Restoring system indices by name is deprecated. Use feature states instead. System indices: " + explicitlyRequestedSystemIndices, new Object[0]);
        }
        this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotId.getName() + ']', new RestoreSnapshotStateTask(request, snapshot, featureStatesToRestore.keySet(), RestoreService.renamedIndices(request, requestedIndicesIncludingSystem, dataStreamIndices, featureStateIndices, repositoryData), snapshotInfo, metadataBuilder.dataStreams(dataStreamsToRestore, dataStreamAliasesToRestore).build(), dataStreamsToRestore.values(), updater, listener));
    }

    private void setRefreshRepositoryUuidOnRestore(boolean refreshRepositoryUuidOnRestore) {
        this.refreshRepositoryUuidOnRestore = refreshRepositoryUuidOnRestore;
    }

    static void refreshRepositoryUuids(boolean enabled, RepositoriesService repositoriesService, final ActionListener<Void> refreshListener) {
        if (!enabled) {
            logger.debug("repository UUID refresh is disabled");
            refreshListener.onResponse(null);
            return;
        }
        java.util.List repositories = repositoriesService.getRepositories().values().stream().filter(repository -> repository instanceof BlobStoreRepository && repository.getMetadata().uuid().equals("_na_")).collect(Collectors.toList());
        if (repositories.isEmpty()) {
            logger.debug("repository UUID refresh is not required");
            refreshListener.onResponse(null);
            return;
        }
        logger.info("refreshing repository UUIDs for repositories [{}]", (Object)repositories.stream().map(repository -> repository.getMetadata().name()).collect(Collectors.joining(",")));
        ActionListener<RepositoryData> groupListener = new GroupedActionListener<Void>(new ActionListener<Collection<Void>>(){

            @Override
            public void onResponse(Collection<Void> ignored) {
                logger.debug("repository UUID refresh completed");
                refreshListener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug("repository UUID refresh failed", (Throwable)e);
                refreshListener.onResponse(null);
            }
        }, repositories.size()).map(repositoryData -> null);
        for (Repository repository2 : repositories) {
            repository2.getRepositoryData(groupListener);
        }
    }

    private boolean isSystemIndex(IndexMetadata indexMetadata) {
        return indexMetadata.isSystem() || this.systemIndices.isSystemName(indexMetadata.getIndex().getName());
    }

    private Tuple<Map<String, DataStream>, Map<String, DataStreamAlias>> getDataStreamsToRestore(Repository repository, SnapshotId snapshotId, SnapshotInfo snapshotInfo, Metadata globalMetadata, java.util.List<String> requestIndices, boolean includeAliases) {
        Map<String, DataStreamAlias> dataStreamAliases;
        Map<String, DataStream> dataStreams;
        java.util.List<String> requestedDataStreams = SnapshotUtils.filterIndices(snapshotInfo.dataStreams(), requestIndices.toArray(new String[0]), IndicesOptions.fromOptions(true, true, true, true));
        if (requestedDataStreams.isEmpty()) {
            dataStreams = Collections.emptyMap();
            dataStreamAliases = Collections.emptyMap();
        } else {
            if (globalMetadata == null) {
                globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId);
            }
            Map<String, DataStream> dataStreamsInSnapshot = globalMetadata.dataStreams();
            dataStreams = new HashMap(requestedDataStreams.size());
            for (String requestedDataStream : requestedDataStreams) {
                DataStream dataStreamInSnapshot = dataStreamsInSnapshot.get(requestedDataStream);
                assert (dataStreamInSnapshot != null) : "DataStream [" + requestedDataStream + "] not found in snapshot";
                dataStreams.put(requestedDataStream, dataStreamInSnapshot);
            }
            if (includeAliases) {
                dataStreamAliases = new HashMap();
                Map<String, DataStreamAlias> dataStreamAliasesInSnapshot = globalMetadata.dataStreamAliases();
                for (DataStreamAlias alias : dataStreamAliasesInSnapshot.values()) {
                    DataStreamAlias copy = alias.intersect(requestedDataStreams::contains);
                    if (copy.getDataStreams().isEmpty()) continue;
                    dataStreamAliases.put(alias.getName(), copy);
                }
            } else {
                dataStreamAliases = Collections.emptyMap();
            }
        }
        return new Tuple<Map<String, DataStream>, Map<String, DataStreamAlias>>(dataStreams, dataStreamAliases);
    }

    private Map<String, java.util.List<String>> getFeatureStatesToRestore(RestoreSnapshotRequest request, SnapshotInfo snapshotInfo, Snapshot snapshot) {
        Map<String, java.util.List<String>> featureStatesToRestore;
        if (snapshotInfo.featureStates() == null) {
            return Collections.emptyMap();
        }
        Map<String, java.util.List> snapshotFeatureStates = snapshotInfo.featureStates().stream().collect(Collectors.toMap(SnapshotFeatureInfo::getPluginName, SnapshotFeatureInfo::getIndices));
        String[] requestedFeatureStates = request.featureStates();
        if (requestedFeatureStates == null || requestedFeatureStates.length == 0) {
            featureStatesToRestore = request.includeGlobalState() ? new HashMap<String, java.util.List>(snapshotFeatureStates) : Collections.emptyMap();
        } else if (requestedFeatureStates.length == 1 && "none".equalsIgnoreCase(requestedFeatureStates[0])) {
            featureStatesToRestore = Collections.emptyMap();
        } else {
            Set<String> requestedStates = org.elasticsearch.core.Set.of(requestedFeatureStates);
            if (requestedStates.contains("none")) {
                throw new SnapshotRestoreException(snapshot, "the feature_states value [none] indicates that no feature states should be restored, but other feature states were requested: " + requestedStates);
            }
            if (!snapshotFeatureStates.keySet().containsAll(requestedStates)) {
                HashSet<String> nonExistingRequestedStates = new HashSet<String>(requestedStates);
                nonExistingRequestedStates.removeAll(snapshotFeatureStates.keySet());
                throw new SnapshotRestoreException(snapshot, "requested feature states [" + nonExistingRequestedStates + "] are not present in snapshot");
            }
            featureStatesToRestore = new HashMap<String, java.util.List>(snapshotFeatureStates);
            featureStatesToRestore.keySet().retainAll(requestedStates);
        }
        java.util.List featuresNotOnThisNode = featureStatesToRestore.keySet().stream().filter(featureName -> !this.systemIndices.getFeatures().containsKey(featureName)).collect(Collectors.toList());
        if (!featuresNotOnThisNode.isEmpty()) {
            throw new SnapshotRestoreException(snapshot, "requested feature states " + featuresNotOnThisNode + " are present in snapshot but those features are not installed on the current master node");
        }
        return featureStatesToRestore;
    }

    private Set<Index> resolveSystemIndicesToDelete(ClusterState currentState, Set<String> featureStatesToRestore) {
        if (featureStatesToRestore == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(featureStatesToRestore.stream().map(featureName -> this.systemIndices.getFeatures().get(featureName)).filter(Objects::nonNull).flatMap(feature -> feature.getIndexDescriptors().stream()).flatMap(descriptor -> descriptor.getMatchingIndices(currentState.metadata()).stream()).map(indexName -> {
            assert (currentState.metadata().hasIndex((String)indexName)) : "index [" + indexName + "] not found in metadata but must be present";
            return currentState.metadata().getIndices().get((String)indexName).getIndex();
        }).collect(Collectors.toSet()));
    }

    static DataStream updateDataStream(DataStream dataStream, Metadata.Builder metadata, RestoreSnapshotRequest request) {
        String dataStreamName = dataStream.getName();
        if (request.renamePattern() != null && request.renameReplacement() != null) {
            dataStreamName = dataStreamName.replaceAll(request.renamePattern(), request.renameReplacement());
        }
        java.util.List<Index> updatedIndices = dataStream.getIndices().stream().map(i -> metadata.get(RestoreService.renameIndex(i.getName(), request, true)).getIndex()).collect(Collectors.toList());
        return new DataStream(dataStreamName, dataStream.getTimeStampField(), updatedIndices, dataStream.getGeneration(), dataStream.getMetadata(), dataStream.isHidden(), dataStream.isReplicated(), dataStream.isSystem());
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    private static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (!status.state().completed()) {
                return nonCompletedState;
            }
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private static Map<String, IndexId> renamedIndices(RestoreSnapshotRequest request, java.util.List<String> filteredIndices, Set<String> dataStreamIndices, Set<String> featureIndices, RepositoryData repositoryData) {
        HashMap<String, IndexId> renamedIndices = new HashMap<String, IndexId>();
        for (String index : filteredIndices) {
            String renamedIndex = featureIndices.contains(index) ? index : RestoreService.renameIndex(index, request, dataStreamIndices.contains(index));
            IndexId previousIndex = renamedIndices.put(renamedIndex, repositoryData.resolveIndexId(index));
            if (previousIndex == null) continue;
            throw new SnapshotRestoreException(request.repository(), request.snapshot(), "indices [" + index + "] and [" + previousIndex.getName() + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private static String renameIndex(String index, RestoreSnapshotRequest request, boolean partOfDataStream) {
        String renamedIndex = index;
        if (request.renameReplacement() != null && request.renamePattern() != null) {
            boolean bl = partOfDataStream = partOfDataStream && index.startsWith(".ds-");
            if (partOfDataStream) {
                index = index.substring(".ds-".length());
            }
            renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            if (partOfDataStream) {
                renamedIndex = ".ds-" + renamedIndex;
            }
        }
        return renamedIndex;
    }

    private static void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + (Object)((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with Elasticsearch version [" + snapshotInfo.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
        if (snapshotInfo.version().before(Version.CURRENT.minimumIndexCompatibilityVersion())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with Elasticsearch version [" + snapshotInfo.version() + "] which is below the current versions minimum index compatibility version [" + Version.CURRENT.minimumIndexCompatibilityVersion() + "]");
        }
    }

    public static boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                Index index = ((ShardId)objectObjectCursor.key).getIndex();
                if (!indicesToCheck.contains(index) || ((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || currentState.getMetadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        return state.custom("restore", RestoreInProgress.EMPTY).get(restoreUUID);
    }

    private void removeCompletedRestoresFromClusterState() {
        this.clusterService.submitStateUpdateTask("clean up snapshot restore status", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
                boolean changed = false;
                for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
                    if (entry.state().completed()) {
                        changed = true;
                        continue;
                    }
                    restoreInProgressBuilder.add(entry);
                }
                return !changed ? currentState : ClusterState.builder(currentState).putCustom("restore", restoreInProgressBuilder.build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                RestoreService.this.cleanupInProgress = false;
                logger.warn(() -> new ParameterizedMessage("failed to remove completed restores from cluster state", new Object[0]), (Throwable)e);
            }

            @Override
            public void onNoLongerMaster(String source) {
                RestoreService.this.cleanupInProgress = false;
                logger.debug("no longer master while removing completed restores from cluster state");
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                RestoreService.this.cleanupInProgress = false;
            }
        });
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        block5: {
            try {
                if (!event.localNodeMaster() || this.cleanupInProgress) break block5;
                for (RestoreInProgress.Entry entry : event.state().custom("restore", RestoreInProgress.EMPTY)) {
                    if (!entry.state().completed()) continue;
                    assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
                    this.removeCompletedRestoresFromClusterState();
                    this.cleanupInProgress = true;
                    break;
                }
            }
            catch (Exception t) {
                assert (false) : t;
                logger.warn("Failed to update restore state ", (Throwable)t);
            }
        }
    }

    private static IndexMetadata updateIndexSettings(Snapshot snapshot, IndexMetadata indexMetadata, Settings changeSettings, String[] ignoreSettings) {
        Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(changeSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(changeSettings).booleanValue()) {
            throw new SnapshotRestoreException(snapshot, "cannot disable setting [" + IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey() + "] on restore");
        }
        IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
        Settings settings = indexMetadata.getSettings();
        HashSet<String> keyFilters = new HashSet<String>();
        ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
        for (String ignoredSetting : ignoreSettings) {
            if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                    throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                }
                keyFilters.add(ignoredSetting);
                continue;
            }
            simpleMatchPatterns.add(ignoredSetting);
        }
        Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(k -> {
            if (!UNREMOVABLE_SETTINGS.contains(k)) {
                for (String filterKey : keyFilters) {
                    if (!k.equals(filterKey)) continue;
                    return false;
                }
                for (String pattern : simpleMatchPatterns) {
                    if (!Regex.simpleMatch(pattern, k)) continue;
                    return false;
                }
            }
            return true;
        })).put(normalizedChangeSettings.filter(k -> {
            if (UNMODIFIABLE_SETTINGS.contains(k)) {
                throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
            }
            return true;
        }));
        settingsBuilder.remove(MetadataIndexStateService.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
        return builder.settings(settingsBuilder).build();
    }

    private static IndexMetadata.Builder restoreToCreateNewIndex(IndexMetadata snapshotIndexMetadata, String renamedIndexName) {
        return IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).index(renamedIndexName).settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", UUIDs.randomBase64UUID())).timestampRange(IndexLongFieldRange.NO_SHARDS);
    }

    private static IndexMetadata.Builder restoreOverClosedIndex(IndexMetadata snapshotIndexMetadata, IndexMetadata currentIndexMetadata, ClusterState currentState) {
        Settings.Builder indexSettingsBuilder = Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", currentIndexMetadata.getIndexUUID());
        if (snapshotIndexMetadata.getCreationVersion().onOrAfter(Version.V_7_9_0) || currentState.nodes().getMinNodeVersion().onOrAfter(Version.V_7_9_0)) {
            indexSettingsBuilder.put("index.history.uuid", UUIDs.randomBase64UUID());
        }
        IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion())).mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion())).settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion())).aliasesVersion(Math.max(snapshotIndexMetadata.getAliasesVersion(), 1L + currentIndexMetadata.getAliasesVersion())).timestampRange(IndexLongFieldRange.NO_SHARDS).index(currentIndexMetadata.getIndex().getName()).settings(indexSettingsBuilder);
        for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
            indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
        }
        return indexMdBuilder;
    }

    private void ensureValidIndexName(ClusterState currentState, IndexMetadata snapshotIndexMetadata, String renamedIndexName) {
        boolean isHidden = snapshotIndexMetadata.isHidden();
        this.createIndexService.validateIndexName(renamedIndexName, currentState);
        this.createIndexService.validateDotIndex(renamedIndexName, isHidden);
        this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetadata.getSettings(), false);
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
    }

    private final class RestoreSnapshotStateTask
    extends ClusterStateUpdateTask {
        private final String restoreUUID;
        private final RestoreSnapshotRequest request;
        private final Set<String> featureStatesToRestore;
        private final Map<String, IndexId> indicesToRestore;
        private final Snapshot snapshot;
        private final SnapshotInfo snapshotInfo;
        private final Metadata metadata;
        private final Collection<DataStream> dataStreamsToRestore;
        private final BiConsumer<ClusterState, Metadata.Builder> updater;
        private final ActionListener<RestoreCompletionResponse> listener;
        @Nullable
        private RestoreInfo restoreInfo;

        RestoreSnapshotStateTask(RestoreSnapshotRequest request, Snapshot snapshot, Set<String> featureStatesToRestore, Map<String, IndexId> indicesToRestore, SnapshotInfo snapshotInfo, Metadata metadata, Collection<DataStream> dataStreamsToRestore, BiConsumer<ClusterState, Metadata.Builder> updater, ActionListener<RestoreCompletionResponse> listener) {
            super(request.masterNodeTimeout());
            this.restoreUUID = UUIDs.randomBase64UUID();
            this.request = request;
            this.snapshot = snapshot;
            this.featureStatesToRestore = featureStatesToRestore;
            this.indicesToRestore = indicesToRestore;
            this.snapshotInfo = snapshotInfo;
            this.metadata = metadata;
            this.dataStreamsToRestore = dataStreamsToRestore;
            this.updater = updater;
            this.listener = listener;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
            if (currentState.getNodes().getMinNodeVersion().before(Version.V_7_0_0) && !restoreInProgress.isEmpty()) {
                throw new ConcurrentSnapshotExecutionException(this.snapshot, "Restore process is already running in this cluster");
            }
            this.ensureSnapshotNotDeleted(currentState);
            currentState = RestoreService.this.metadataDeleteIndexService.deleteIndices(currentState, RestoreService.this.resolveSystemIndicesToDelete(currentState, this.featureStatesToRestore));
            Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
            Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
            String localNodeId = RestoreService.this.clusterService.state().nodes().getLocalNodeId();
            for (Map.Entry<String, IndexId> indexEntry : this.indicesToRestore.entrySet()) {
                IndexMetadata updatedIndexMetadata;
                IndexMetadata.Builder indexMdBuilder;
                IndexId index = indexEntry.getValue();
                IndexMetadata snapshotIndexMetadata = RestoreService.updateIndexSettings(this.snapshot, this.metadata.index(index.getName()), this.request.indexSettings(), this.request.ignoreIndexSettings());
                try {
                    snapshotIndexMetadata = RestoreService.this.indexMetadataVerifier.verifyIndexMetadata(snapshotIndexMetadata, minIndexCompatibilityVersion);
                }
                catch (Exception ex) {
                    throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                }
                String renamedIndexName = indexEntry.getKey();
                IndexMetadata currentIndexMetadata = currentState.metadata().index(renamedIndexName);
                RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, this.snapshot, this.snapshotInfo.version(), index);
                boolean partial = this.checkPartial(index.getName());
                IntHashSet ignoreShards = new IntHashSet();
                if (currentIndexMetadata == null) {
                    RestoreService.this.ensureValidIndexName(currentState, snapshotIndexMetadata, renamedIndexName);
                    RestoreService.this.shardLimitValidator.validateShardLimit(snapshotIndexMetadata.getSettings(), currentState);
                    indexMdBuilder = RestoreService.restoreToCreateNewIndex(snapshotIndexMetadata, renamedIndexName);
                    if (!(this.request.includeAliases() || snapshotIndexMetadata.getAliases().isEmpty() || RestoreService.this.isSystemIndex(snapshotIndexMetadata))) {
                        indexMdBuilder.removeAllAliases();
                    } else {
                        this.ensureNoAliasNameConflicts(snapshotIndexMetadata);
                    }
                    updatedIndexMetadata = indexMdBuilder.build();
                    if (partial) {
                        this.populateIgnoredShards(index.getName(), ignoreShards);
                    }
                    rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource, ignoreShards);
                    blocks.addBlocks(updatedIndexMetadata);
                } else {
                    this.validateExistingClosedIndex(currentIndexMetadata, snapshotIndexMetadata, renamedIndexName, partial);
                    indexMdBuilder = RestoreService.restoreOverClosedIndex(snapshotIndexMetadata, currentIndexMetadata, currentState);
                    if (!this.request.includeAliases() && !RestoreService.this.isSystemIndex(snapshotIndexMetadata)) {
                        if (!snapshotIndexMetadata.getAliases().isEmpty()) {
                            indexMdBuilder.removeAllAliases();
                        }
                        for (AliasMetadata alias : currentIndexMetadata.getAliases().values()) {
                            indexMdBuilder.putAlias(alias);
                        }
                    } else {
                        this.ensureNoAliasNameConflicts(snapshotIndexMetadata);
                    }
                    updatedIndexMetadata = indexMdBuilder.build();
                    rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                    blocks.updateBlocks(updatedIndexMetadata);
                }
                mdBuilder.put(updatedIndexMetadata, true);
                Index renamedIndex = updatedIndexMetadata.getIndex();
                for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                    shardsBuilder.put(new ShardId(renamedIndex, shard), ignoreShards.contains(shard) ? new RestoreInProgress.ShardRestoreStatus(localNodeId, RestoreInProgress.State.FAILURE) : new RestoreInProgress.ShardRestoreStatus(localNodeId));
                }
            }
            ClusterState.Builder builder = ClusterState.builder(currentState);
            ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
            if (!shards.isEmpty()) {
                builder.putCustom("restore", new RestoreInProgress.Builder(currentState.custom("restore", RestoreInProgress.EMPTY)).add(new RestoreInProgress.Entry(this.restoreUUID, this.snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), List.copyOf(this.indicesToRestore.keySet()), shards)).build());
            }
            this.applyDataStreamRestores(currentState, mdBuilder);
            if (this.request.includeGlobalState()) {
                this.applyGlobalStateRestore(currentState, mdBuilder);
            }
            if (RestoreService.completed(shards)) {
                this.restoreInfo = new RestoreInfo(this.snapshot.getSnapshotId().getName(), List.copyOf(this.indicesToRestore.keySet()), shards.size(), shards.size() - RestoreService.failedShards(shards));
            }
            this.updater.accept(currentState, mdBuilder);
            return RestoreService.this.allocationService.reroute(builder.metadata(mdBuilder).blocks(blocks).routingTable(rtBuilder.build()).build(), "restored snapshot [" + this.snapshot + "]");
        }

        private void applyDataStreamRestores(ClusterState currentState, Metadata.Builder mdBuilder) {
            HashMap<String, DataStream> updatedDataStreams = new HashMap<String, DataStream>(currentState.metadata().dataStreams());
            updatedDataStreams.putAll(this.dataStreamsToRestore.stream().map(ds -> RestoreService.updateDataStream(ds, mdBuilder, this.request)).collect(Collectors.toMap(DataStream::getName, Function.identity())));
            HashMap<String, DataStreamAlias> updatedDataStreamAliases = new HashMap<String, DataStreamAlias>(currentState.metadata().dataStreamAliases());
            this.metadata.dataStreamAliases().values().stream().map(alias -> {
                if (this.request.renamePattern() != null && this.request.renameReplacement() != null) {
                    return alias.renameDataStreams(this.request.renamePattern(), this.request.renameReplacement());
                }
                return alias;
            }).forEach(alias -> {
                DataStreamAlias current = updatedDataStreamAliases.putIfAbsent(alias.getName(), (DataStreamAlias)alias);
                if (current != null) {
                    DataStreamAlias newInstance = alias.merge(current);
                    updatedDataStreamAliases.put(alias.getName(), newInstance);
                }
            });
            mdBuilder.dataStreams(updatedDataStreams, updatedDataStreamAliases);
        }

        private void ensureSnapshotNotDeleted(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
            if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(this.snapshot.getSnapshotId()))) {
                throw new ConcurrentSnapshotExecutionException(this.snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + deletionsInProgress.getEntries().get(0) + "]");
            }
        }

        private void applyGlobalStateRestore(ClusterState currentState, Metadata.Builder mdBuilder) {
            if (this.metadata.persistentSettings() != null) {
                Set set;
                Settings settings = this.metadata.persistentSettings();
                if (this.request.skipOperatorOnlyState() && !(set = Stream.concat(settings.keySet().stream(), currentState.metadata().persistentSettings().keySet().stream()).filter(k -> {
                    Setting<?> setting = RestoreService.this.clusterSettings.get((String)k);
                    return setting != null && setting.isOperatorOnly();
                }).collect(Collectors.toSet())).isEmpty()) {
                    settings = Settings.builder().put(settings.filter(k -> false == operatorSettingKeys.contains(k))).put(currentState.metadata().persistentSettings().filter(set::contains)).build();
                }
                RestoreService.this.clusterSettings.validateUpdate(settings);
                mdBuilder.persistentSettings(settings);
            }
            if (this.metadata.templates() != null) {
                for (IndexTemplateMetadata indexTemplateMetadata : this.metadata.templates().values()) {
                    mdBuilder.put(indexTemplateMetadata);
                }
            }
            if (this.metadata.customs() != null) {
                for (ObjectObjectCursor objectObjectCursor : this.metadata.customs()) {
                    if ("repositories".equals(objectObjectCursor.key) || "data_stream".equals(objectObjectCursor.key) || objectObjectCursor.value instanceof Metadata.NonRestorableCustom) continue;
                    mdBuilder.putCustom((String)objectObjectCursor.key, (Metadata.Custom)objectObjectCursor.value);
                }
            }
        }

        private void ensureNoAliasNameConflicts(IndexMetadata snapshotIndexMetadata) {
            for (ObjectCursor alias : snapshotIndexMetadata.getAliases().keys()) {
                String aliasName = (String)alias.value;
                IndexId indexId = this.indicesToRestore.get(aliasName);
                if (indexId == null) continue;
                throw new SnapshotRestoreException(this.snapshot, "cannot rename index [" + indexId + "] into [" + aliasName + "] because of conflict with an alias with the same name");
            }
        }

        private void populateIgnoredShards(String index, IntSet ignoreShards) {
            for (SnapshotShardFailure failure : this.snapshotInfo.shardFailures()) {
                if (!index.equals(failure.index())) continue;
                ignoreShards.add(failure.shardId());
            }
        }

        private boolean checkPartial(String index) {
            if (RestoreService.failed(this.snapshotInfo, index)) {
                if (this.request.partial()) {
                    return true;
                }
                throw new SnapshotRestoreException(this.snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
            }
            return false;
        }

        private void validateExistingClosedIndex(IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex, boolean partial) {
            if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
            }
            if (partial) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
            }
            if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
            }
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)this.snapshot), (Throwable)e);
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(new RestoreCompletionResponse(this.restoreUUID, this.snapshot, this.restoreInfo));
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>> shardChanges = new HashMap<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes(recoverySource).put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                this.changes(recoverySource).put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes(unassignedShard.recoverySource()).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + initializedShard.recoverySource()));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(recoverySource).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Map<ShardId, RestoreInProgress.ShardRestoreStatus> changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), k -> new HashMap());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Map<ShardId, RestoreInProgress.ShardRestoreStatus> updates = this.shardChanges.get(entry.uuid());
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(shardStates);
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : updates.entrySet()) {
                            ShardId shardId = shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }
    }

    public static final class RestoreCompletionResponse {
        private final String uuid;
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
            this.uuid = uuid;
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

