/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.index.analysis.AnalyzerComponentsProvider;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public final class FragmentBuilderHelper {
    private FragmentBuilderHelper() {
    }

    public static FieldFragList.WeightedFragInfo fixWeightedFragInfo(FieldFragList.WeightedFragInfo fragInfo) {
        assert (fragInfo != null) : "FragInfo must not be null";
        if (!fragInfo.getSubInfos().isEmpty()) {
            List<FieldFragList.WeightedFragInfo.SubInfo> subInfos = fragInfo.getSubInfos();
            CollectionUtil.introSort(subInfos, (o1, o2) -> {
                int startOffset = o1.getTermsOffsets().get(0).getStartOffset();
                int startOffset2 = o2.getTermsOffsets().get(0).getStartOffset();
                return FragmentBuilderHelper.compare(startOffset, startOffset2);
            });
            return new FieldFragList.WeightedFragInfo(Math.min(fragInfo.getSubInfos().get(0).getTermsOffsets().get(0).getStartOffset(), fragInfo.getStartOffset()), fragInfo.getEndOffset(), subInfos, fragInfo.getTotalBoost());
        }
        return fragInfo;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static boolean containsBrokenAnalysis(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof AnalyzerComponentsProvider) {
            TokenFilterFactory[] tokenFilters;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = ((AnalyzerComponentsProvider)((Object)analyzer)).getComponents().getTokenFilters()) {
                if (!tokenFilterFactory.breaksFastVectorHighlighter()) continue;
                return true;
            }
        }
        return false;
    }
}

