/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.NXYSignificanceHeuristic;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class GND
extends NXYSignificanceHeuristic {
    public static final String NAME = "gnd";
    public static final ConstructingObjectParser<GND, Void> PARSER = new ConstructingObjectParser("gnd", args -> {
        boolean backgroundIsSuperset = args[0] == null ? true : (Boolean)args[0];
        return new GND(backgroundIsSuperset);
    });

    public GND(boolean backgroundIsSuperset) {
        super(true, backgroundIsSuperset);
    }

    public GND(StreamInput in) throws IOException {
        super(true, in.readBoolean());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.backgroundIsSuperset);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GND)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int result = NAME.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        NXYSignificanceHeuristic.Frequencies frequencies = this.computeNxys(subsetFreq, subsetSize, supersetFreq, supersetSize, "GND");
        double fx = frequencies.N1_;
        double fy = frequencies.N_1;
        double fxy = frequencies.N11;
        double N = frequencies.N;
        if (fxy == 0.0) {
            return 0.0;
        }
        if (fx == fy && fx == fxy) {
            return 1.0;
        }
        double score = (Math.max(Math.log(fx), Math.log(fy)) - Math.log(fxy)) / (Math.log(N) - Math.min(Math.log(fx), Math.log(fy)));
        score = Math.exp(-1.0 * score);
        return score;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), BACKGROUND_IS_SUPERSET);
    }

    public static class GNDBuilder
    extends NXYSignificanceHeuristic.NXYBuilder {
        public GNDBuilder(boolean backgroundIsSuperset) {
            super(true, backgroundIsSuperset);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(GND.NAME);
            builder.field(NXYSignificanceHeuristic.BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
            builder.endObject();
            return builder;
        }
    }
}

