/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.NodeAndClusterIdConverter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;

public class NodeAndClusterIdStateListener
implements ClusterStateObserver.Listener {
    private static final Logger logger = LogManager.getLogger(NodeAndClusterIdStateListener.class);
    static final SetOnce<Tuple<String, String>> nodeAndClusterId = new SetOnce();

    private NodeAndClusterIdStateListener() {
    }

    public static void getAndSetNodeIdAndClusterId(ClusterService clusterService, ThreadContext threadContext) {
        ClusterState clusterState = clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, logger, threadContext);
        observer.waitForNextChange((ClusterStateObserver.Listener)new NodeAndClusterIdStateListener(), NodeAndClusterIdStateListener::isNodeAndClusterIdPresent);
    }

    private static boolean isNodeAndClusterIdPresent(ClusterState clusterState) {
        return NodeAndClusterIdStateListener.getNodeId(clusterState) != null && NodeAndClusterIdStateListener.getClusterUUID(clusterState) != null;
    }

    private static String getClusterUUID(ClusterState state) {
        return state.getMetadata().clusterUUID();
    }

    private static String getNodeId(ClusterState state) {
        return state.getNodes().getLocalNodeId();
    }

    @Override
    public void onNewClusterState(ClusterState state) {
        String nodeId = NodeAndClusterIdStateListener.getNodeId(state);
        String clusterUUID = NodeAndClusterIdStateListener.getClusterUUID(state);
        logger.debug("Received cluster state update. Setting nodeId=[{}] and clusterUuid=[{}]", (Object)nodeId, (Object)clusterUUID);
        NodeAndClusterIdConverter.setNodeIdAndClusterId(nodeId, clusterUUID);
        this.setNodeIdAndClusterId(nodeId, clusterUUID);
    }

    void setNodeIdAndClusterId(String nodeId, String clusterUUID) {
        nodeAndClusterId.set(Tuple.tuple(nodeId, clusterUUID));
    }

    @Override
    public void onClusterServiceClose() {
    }

    @Override
    public void onTimeout(TimeValue timeout) {
    }
}

