/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class UpgradeTransformsResponse {
    public static final ParseField NO_ACTION = new ParseField("no_action", new String[0]);
    public static final ParseField UPDATED = new ParseField("updated", new String[0]);
    public static final ParseField NEEDS_UPDATE = new ParseField("needs_update", new String[0]);
    private static final ConstructingObjectParser<UpgradeTransformsResponse, Void> PARSER = new ConstructingObjectParser("upgrade_transform", true, args -> {
        long updated = args[0] == null ? 0L : (Long)args[0];
        long noAction = args[1] == null ? 0L : (Long)args[1];
        long needsUpdate = args[2] == null ? 0L : (Long)args[2];
        return new UpgradeTransformsResponse(updated, noAction, needsUpdate);
    });
    private final long updated;
    private final long noAction;
    private final long needsUpdate;

    public static UpgradeTransformsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public UpgradeTransformsResponse(long updated, long noAction, long needsUpdate) {
        this.updated = updated;
        this.noAction = noAction;
        this.needsUpdate = needsUpdate;
    }

    public int hashCode() {
        return Objects.hash(this.updated, this.noAction, this.needsUpdate);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpgradeTransformsResponse that = (UpgradeTransformsResponse)other;
        return this.updated == that.updated && this.noAction == that.noAction && this.needsUpdate == that.needsUpdate;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getNoAction() {
        return this.noAction;
    }

    public long getNeedsUpdate() {
        return this.needsUpdate;
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), UPDATED);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), NO_ACTION);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), NEEDS_UPDATE);
    }
}

