/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class CreateApiKeyResponse {
    private final String name;
    private final String id;
    private final SecureString key;
    private final Instant expiration;
    static final ConstructingObjectParser<CreateApiKeyResponse, Void> PARSER = new ConstructingObjectParser("create_api_key_response", args -> {
        String id = (String)args[1];
        String key = (String)args[2];
        if (args[4] != null && !args[4].equals(CreateApiKeyResponse.encode(id, key))) {
            throw new IllegalArgumentException("the encoded value does not match id and api_key");
        }
        return new CreateApiKeyResponse((String)args[0], id, new SecureString(key.toCharArray()), args[3] == null ? null : Instant.ofEpochMilli((Long)args[3]));
    });

    public CreateApiKeyResponse(String name, String id, SecureString key, Instant expiration) {
        this.name = name;
        this.id = id;
        this.key = key;
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public SecureString getKey() {
        return this.key;
    }

    public SecureString getEncoded() {
        return new SecureString(CreateApiKeyResponse.encode(this.id, this.key).toCharArray());
    }

    @Nullable
    public Instant getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.key, this.expiration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateApiKeyResponse other = (CreateApiKeyResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.expiration, other.expiration);
    }

    private static String encode(CharSequence id, CharSequence key) {
        return Base64.getEncoder().encodeToString((id + ":" + key).getBytes(StandardCharsets.UTF_8));
    }

    public static CreateApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("api_key", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("encoded", new String[0]));
    }
}

