/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TargetMeanEncoding
implements PreProcessor {
    public static final String NAME = "target_mean_encoding";
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField TARGET_MAP = new ParseField("target_map", new String[0]);
    public static final ParseField DEFAULT_VALUE = new ParseField("default_value", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    public static final ConstructingObjectParser<TargetMeanEncoding, Void> PARSER = new ConstructingObjectParser("target_mean_encoding", true, a -> new TargetMeanEncoding((String)a[0], (String)a[1], (Map)a[2], (Double)a[3], (Boolean)a[4]));
    private final String field;
    private final String featureName;
    private final Map<String, Double> meanMap;
    private final double defaultValue;
    private final Boolean custom;

    public static TargetMeanEncoding fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    TargetMeanEncoding(String field, String featureName, Map<String, Double> meanMap, Double defaultValue, Boolean custom) {
        this.field = Objects.requireNonNull(field);
        this.featureName = Objects.requireNonNull(featureName);
        this.meanMap = Collections.unmodifiableMap(Objects.requireNonNull(meanMap));
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.custom = custom;
    }

    public String getField() {
        return this.field;
    }

    public Map<String, Double> getMeanMap() {
        return this.meanMap;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Boolean getCustom() {
        return this.custom;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(TARGET_MAP.getPreferredName(), this.meanMap);
        builder.field(DEFAULT_VALUE.getPreferredName(), this.defaultValue);
        if (this.custom != null) {
            builder.field(CUSTOM.getPreferredName(), this.custom);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetMeanEncoding that = (TargetMeanEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.meanMap, that.meanMap) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featureName, this.meanMap, this.defaultValue, this.custom);
    }

    public Builder builder(String fieldName) {
        return new Builder(fieldName);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), TARGET_MAP);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), DEFAULT_VALUE);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
    }

    public static class Builder {
        private String field;
        private String featureName;
        private Map<String, Double> meanMap = new HashMap<String, Double>();
        private double defaultValue;
        private Boolean custom;

        public Builder(String field) {
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setFeatureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public Builder setMeanMap(Map<String, Double> meanMap) {
            this.meanMap = meanMap;
            return this;
        }

        public Builder addMeanMapEntry(String valueName, double meanEncoding) {
            this.meanMap.put(valueName, meanEncoding);
            return this;
        }

        public Builder setDefaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setCustom(boolean custom) {
            this.custom = custom;
            return this;
        }

        public TargetMeanEncoding build() {
            return new TargetMeanEncoding(this.field, this.featureName, this.meanMap, this.defaultValue, this.custom);
        }
    }
}

