/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RunningState
implements ToXContentObject {
    private static final ParseField REAL_TIME_CONFIGURED = new ParseField("real_time_configured", new String[0]);
    private static final ParseField REAL_TIME_RUNNING = new ParseField("real_time_running", new String[0]);
    public static final ConstructingObjectParser<RunningState, Void> PARSER = new ConstructingObjectParser("datafeed_running_state", true, a -> new RunningState((Boolean)a[0], (Boolean)a[1]));
    private final boolean realTimeConfigured;
    private final boolean realTimeRunning;

    public RunningState(boolean realTimeConfigured, boolean realTimeRunning) {
        this.realTimeConfigured = realTimeConfigured;
        this.realTimeRunning = realTimeRunning;
    }

    public boolean isRealTimeConfigured() {
        return this.realTimeConfigured;
    }

    public boolean isRealTimeRunning() {
        return this.realTimeRunning;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunningState that = (RunningState)o;
        return this.realTimeConfigured == that.realTimeConfigured && this.realTimeRunning == that.realTimeRunning;
    }

    public int hashCode() {
        return Objects.hash(this.realTimeConfigured, this.realTimeRunning);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REAL_TIME_CONFIGURED.getPreferredName(), this.realTimeConfigured);
        builder.field(REAL_TIME_RUNNING.getPreferredName(), this.realTimeRunning);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), REAL_TIME_CONFIGURED);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), REAL_TIME_RUNNING);
    }
}

