/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.core.PageParams;
import org.elasticsearch.client.transform.DeleteTransformRequest;
import org.elasticsearch.client.transform.GetTransformRequest;
import org.elasticsearch.client.transform.GetTransformStatsRequest;
import org.elasticsearch.client.transform.PreviewTransformRequest;
import org.elasticsearch.client.transform.PutTransformRequest;
import org.elasticsearch.client.transform.StartTransformRequest;
import org.elasticsearch.client.transform.StopTransformRequest;
import org.elasticsearch.client.transform.UpdateTransformRequest;
import org.elasticsearch.common.Strings;

final class TransformRequestConverters {
    private TransformRequestConverters() {
    }

    static Request putTransform(PutTransformRequest putRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(putRequest.getConfig().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        if (putRequest.getDeferValidation() != null) {
            request.addParameter("defer_validation", Boolean.toString(putRequest.getDeferValidation()));
        }
        return request;
    }

    static Request updateTransform(UpdateTransformRequest updateTransformRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(updateTransformRequest.getId()).addPathPart("_update").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(updateTransformRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        if (updateTransformRequest.getDeferValidation() != null) {
            request.addParameter("defer_validation", Boolean.toString(updateTransformRequest.getDeferValidation()));
        }
        return request;
    }

    static Request getTransform(GetTransformRequest getRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(Strings.collectionToCommaDelimitedString(getRequest.getId())).build();
        Request request = new Request("GET", endpoint);
        if (getRequest.getPageParams() != null && getRequest.getPageParams().getFrom() != null) {
            request.addParameter(PageParams.FROM.getPreferredName(), getRequest.getPageParams().getFrom().toString());
        }
        if (getRequest.getPageParams() != null && getRequest.getPageParams().getSize() != null) {
            request.addParameter(PageParams.SIZE.getPreferredName(), getRequest.getPageParams().getSize().toString());
        }
        if (getRequest.getAllowNoMatch() != null) {
            request.addParameter("allow_no_match", getRequest.getAllowNoMatch().toString());
        }
        if (getRequest.getExcludeGenerated() != null) {
            request.addParameter("exclude_generated", getRequest.getExcludeGenerated().toString());
        }
        return request;
    }

    static Request deleteTransform(DeleteTransformRequest deleteRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(deleteRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        if (deleteRequest.getForce() != null) {
            request.addParameter("force", Boolean.toString(deleteRequest.getForce()));
        }
        return request;
    }

    static Request startTransform(StartTransformRequest startRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(startRequest.getId()).addPathPartAsIs("_start").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        if (startRequest.getTimeout() != null) {
            params.withTimeout(startRequest.getTimeout());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request stopTransform(StopTransformRequest stopRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(stopRequest.getId()).addPathPartAsIs("_stop").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        if (stopRequest.getWaitForCompletion() != null) {
            params.withWaitForCompletion(stopRequest.getWaitForCompletion());
        }
        if (stopRequest.getTimeout() != null) {
            params.withTimeout(stopRequest.getTimeout());
        }
        if (stopRequest.getAllowNoMatch() != null) {
            request.addParameter("allow_no_match", stopRequest.getAllowNoMatch().toString());
        }
        if (stopRequest.getWaitForCheckpoint() != null) {
            request.addParameter("wait_for_checkpoint", stopRequest.getWaitForCheckpoint().toString());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request previewTransform(PreviewTransformRequest previewRequest) throws IOException {
        RequestConverters.EndpointBuilder endpointBuilder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform");
        if (previewRequest.getTransformId() != null) {
            endpointBuilder.addPathPart(previewRequest.getTransformId());
        }
        endpointBuilder.addPathPartAsIs("_preview");
        String endpoint = endpointBuilder.build();
        Request request = new Request("POST", endpoint);
        if (previewRequest.getTransformId() == null) {
            request.setEntity(RequestConverters.createEntity(previewRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        }
        return request;
    }

    static Request getTransformStats(GetTransformStatsRequest statsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_transform").addPathPart(statsRequest.getId()).addPathPartAsIs("_stats").build();
        Request request = new Request("GET", endpoint);
        if (statsRequest.getPageParams() != null && statsRequest.getPageParams().getFrom() != null) {
            request.addParameter(PageParams.FROM.getPreferredName(), statsRequest.getPageParams().getFrom().toString());
        }
        if (statsRequest.getPageParams() != null && statsRequest.getPageParams().getSize() != null) {
            request.addParameter(PageParams.SIZE.getPreferredName(), statsRequest.getPageParams().getSize().toString());
        }
        if (statsRequest.getAllowNoMatch() != null) {
            request.addParameter("allow_no_match", statsRequest.getAllowNoMatch().toString());
        }
        return request;
    }
}

