/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.FuzzyTermsEnum;
import org.apache.lucene.search.spell.LuceneLevenshteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;

public class DirectSpellChecker {
    public static final StringDistance INTERNAL_LEVENSHTEIN = new LuceneLevenshteinDistance();
    private int maxEdits = 2;
    private int minPrefix = 1;
    private int maxInspections = 5;
    private float accuracy = 0.5f;
    private float thresholdFrequency = 0.0f;
    private int minQueryLength = 4;
    private int maxQueryLength = Integer.MAX_VALUE;
    private float maxQueryFrequency = 0.01f;
    private boolean lowerCaseTerms = true;
    private Comparator<SuggestWord> comparator = SuggestWordQueue.DEFAULT_COMPARATOR;
    private StringDistance distance = INTERNAL_LEVENSHTEIN;

    public int getMaxEdits() {
        return this.maxEdits;
    }

    public void setMaxEdits(int maxEdits) {
        if (maxEdits < 1 || maxEdits > 2) {
            throw new UnsupportedOperationException("Invalid maxEdits");
        }
        this.maxEdits = maxEdits;
    }

    public int getMinPrefix() {
        return this.minPrefix;
    }

    public void setMinPrefix(int minPrefix) {
        this.minPrefix = minPrefix;
    }

    public int getMaxInspections() {
        return this.maxInspections;
    }

    public void setMaxInspections(int maxInspections) {
        this.maxInspections = maxInspections;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    public float getThresholdFrequency() {
        return this.thresholdFrequency;
    }

    public void setThresholdFrequency(float thresholdFrequency) {
        if (thresholdFrequency >= 1.0f && thresholdFrequency != (float)((int)thresholdFrequency)) {
            throw new IllegalArgumentException("Fractional absolute document frequencies are not allowed");
        }
        this.thresholdFrequency = thresholdFrequency;
    }

    public int getMinQueryLength() {
        return this.minQueryLength;
    }

    public void setMinQueryLength(int minQueryLength) {
        if (minQueryLength > this.maxQueryLength) {
            throw new IllegalArgumentException("minQueryLength must not be greater than maxQueryLength");
        }
        this.minQueryLength = minQueryLength;
    }

    public int getMaxQueryLength() {
        return this.maxQueryLength;
    }

    public void setMaxQueryLength(int maxQueryLength) {
        if (maxQueryLength < this.minQueryLength) {
            throw new IllegalArgumentException("maxQueryLength must not be smaller than minQueryLength");
        }
        this.maxQueryLength = maxQueryLength;
    }

    public float getMaxQueryFrequency() {
        return this.maxQueryFrequency;
    }

    public void setMaxQueryFrequency(float maxQueryFrequency) {
        if (maxQueryFrequency >= 1.0f && maxQueryFrequency != (float)((int)maxQueryFrequency)) {
            throw new IllegalArgumentException("Fractional absolute document frequencies are not allowed");
        }
        this.maxQueryFrequency = maxQueryFrequency;
    }

    public boolean getLowerCaseTerms() {
        return this.lowerCaseTerms;
    }

    public void setLowerCaseTerms(boolean lowerCaseTerms) {
        this.lowerCaseTerms = lowerCaseTerms;
    }

    public Comparator<SuggestWord> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<SuggestWord> comparator) {
        this.comparator = comparator;
    }

    public StringDistance getDistance() {
        return this.distance;
    }

    public void setDistance(StringDistance distance) {
        this.distance = distance;
    }

    public SuggestWord[] suggestSimilar(Term term, int numSug, IndexReader ir) throws IOException {
        return this.suggestSimilar(term, numSug, ir, SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX);
    }

    public SuggestWord[] suggestSimilar(Term term, int numSug, IndexReader ir, SuggestMode suggestMode) throws IOException {
        return this.suggestSimilar(term, numSug, ir, suggestMode, this.accuracy);
    }

    public SuggestWord[] suggestSimilar(Term term, int numSug, IndexReader ir, SuggestMode suggestMode, float accuracy) throws IOException {
        CharsRefBuilder spare = new CharsRefBuilder();
        String text = term.text();
        int textLength = text.codePointCount(0, text.length());
        if (textLength < this.minQueryLength || textLength > this.maxQueryLength) {
            return new SuggestWord[0];
        }
        if (this.lowerCaseTerms) {
            term = new Term(term.field(), text.toLowerCase(Locale.ROOT));
        }
        int docfreq = ir.docFreq(term);
        if (suggestMode == SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX && docfreq > 0) {
            return new SuggestWord[0];
        }
        int maxDoc = ir.maxDoc();
        if (this.maxQueryFrequency >= 1.0f && (float)docfreq > this.maxQueryFrequency) {
            return new SuggestWord[0];
        }
        if (docfreq > (int)Math.ceil(this.maxQueryFrequency * (float)maxDoc)) {
            return new SuggestWord[0];
        }
        if (suggestMode != SuggestMode.SUGGEST_MORE_POPULAR) {
            docfreq = 0;
        }
        if (this.thresholdFrequency >= 1.0f) {
            docfreq = Math.max(docfreq, (int)this.thresholdFrequency);
        } else if (this.thresholdFrequency > 0.0f) {
            docfreq = Math.max(docfreq, (int)(this.thresholdFrequency * (float)maxDoc) - 1);
        }
        Collection<ScoreTerm> terms = null;
        int inspections = numSug * this.maxInspections;
        terms = this.suggestSimilar(term, inspections, ir, docfreq, 1, accuracy, spare);
        if (this.maxEdits > 1 && terms.size() < inspections) {
            HashSet<ScoreTerm> moreTerms = new HashSet<ScoreTerm>();
            moreTerms.addAll(terms);
            moreTerms.addAll(this.suggestSimilar(term, inspections, ir, docfreq, this.maxEdits, accuracy, spare));
            terms = moreTerms;
        }
        SuggestWord[] suggestions = new SuggestWord[terms.size()];
        int index = suggestions.length - 1;
        for (ScoreTerm s : terms) {
            SuggestWord suggestion = new SuggestWord();
            if (s.termAsString == null) {
                spare.copyUTF8Bytes(s.term);
                s.termAsString = spare.toString();
            }
            suggestion.string = s.termAsString;
            suggestion.score = s.score;
            suggestion.freq = s.docfreq;
            suggestions[index--] = suggestion;
        }
        ArrayUtil.timSort(suggestions, Collections.reverseOrder(this.comparator));
        if (numSug < suggestions.length) {
            SuggestWord[] trimmed = new SuggestWord[numSug];
            System.arraycopy(suggestions, 0, trimmed, 0, numSug);
            suggestions = trimmed;
        }
        return suggestions;
    }

    protected Collection<ScoreTerm> suggestSimilar(Term term, int numSug, IndexReader ir, int docfreq, int editDistance, float accuracy, CharsRefBuilder spare) throws IOException {
        BytesRef candidateTerm;
        Terms terms = MultiTerms.getTerms(ir, term.field());
        if (terms == null) {
            return Collections.emptyList();
        }
        FuzzyTermsEnum e = new FuzzyTermsEnum(terms, term, editDistance, Math.max(this.minPrefix, editDistance - 1), true);
        PriorityQueue<ScoreTerm> stQueue = new PriorityQueue<ScoreTerm>();
        BytesRef queryTerm = new BytesRef(term.text());
        ScoreTerm st = new ScoreTerm();
        while ((candidateTerm = e.next()) != null) {
            String termAsString;
            int df;
            float score = e.getBoost();
            if (stQueue.size() >= numSug && score <= stQueue.peek().boost || queryTerm.bytesEquals(candidateTerm) || (df = e.docFreq()) <= docfreq) continue;
            if (this.distance == INTERNAL_LEVENSHTEIN) {
                termAsString = null;
            } else {
                spare.copyUTF8Bytes(candidateTerm);
                termAsString = spare.toString();
                score = this.distance.getDistance(term.text(), termAsString);
            }
            if (score < accuracy) continue;
            st.term = BytesRef.deepCopyOf(candidateTerm);
            st.boost = score;
            st.docfreq = df;
            st.termAsString = termAsString;
            st.score = score;
            stQueue.offer(st);
            st = stQueue.size() > numSug ? stQueue.poll() : new ScoreTerm();
            e.setMaxNonCompetitiveBoost(stQueue.size() >= numSug ? stQueue.peek().boost : Float.NEGATIVE_INFINITY);
        }
        return stQueue;
    }

    protected static class ScoreTerm
    implements Comparable<ScoreTerm> {
        public BytesRef term;
        public float boost;
        public int docfreq;
        public String termAsString;
        public float score;

        @Override
        public int compareTo(ScoreTerm other) {
            if (this.term.bytesEquals(other.term)) {
                return 0;
            }
            if (this.boost == other.boost) {
                return other.term.compareTo(this.term);
            }
            return Float.compare(this.boost, other.boost);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScoreTerm other = (ScoreTerm)obj;
            return !(this.term == null ? other.term != null : !this.term.bytesEquals(other.term));
        }
    }
}

