/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.join.ToParentDocValues;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;

public class BlockJoinSelector {
    private BlockJoinSelector() {
    }

    public static Bits wrap(final Bits docsWithValue, final BitSet parents, final BitSet children) {
        return new Bits(){

            @Override
            public boolean get(int docID) {
                assert (parents.get(docID)) : "this selector may only be used on parent documents";
                if (docID == 0) {
                    return false;
                }
                int firstChild = parents.prevSetBit(docID - 1) + 1;
                int child = children.nextSetBit(firstChild);
                while (child < docID) {
                    if (docsWithValue.get(child)) {
                        return true;
                    }
                    child = children.nextSetBit(child + 1);
                }
                return false;
            }

            @Override
            public int length() {
                return docsWithValue.length();
            }
        };
    }

    @Deprecated
    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selection, BitSet parents, BitSet children) {
        return BlockJoinSelector.wrap(sortedSet, selection, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
    }

    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selection, BitSet parents, DocIdSetIterator children) {
        SortedDocValues values;
        switch (selection) {
            case MIN: {
                values = SortedSetSelector.wrap(sortedSet, SortedSetSelector.Type.MIN);
                break;
            }
            case MAX: {
                values = SortedSetSelector.wrap(sortedSet, SortedSetSelector.Type.MAX);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BlockJoinSelector.wrap(values, selection, parents, children);
    }

    @Deprecated
    public static SortedDocValues wrap(SortedDocValues values, Type selection, BitSet parents, BitSet children) {
        return BlockJoinSelector.wrap(values, selection, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
    }

    public static SortedDocValues wrap(SortedDocValues values, Type selection, BitSet parents, DocIdSetIterator children) {
        if (values.docID() != -1) {
            throw new IllegalArgumentException("values iterator was already consumed: values.docID=" + values.docID());
        }
        return ToParentDocValues.wrap(values, selection, parents, children);
    }

    @Deprecated
    public static NumericDocValues wrap(SortedNumericDocValues sortedNumerics, Type selection, BitSet parents, BitSet children) {
        return BlockJoinSelector.wrap(sortedNumerics, selection, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
    }

    protected static BitSetIterator toIter(BitSet children) {
        return new BitSetIterator(children, 0L);
    }

    public static NumericDocValues wrap(SortedNumericDocValues sortedNumerics, Type selection, BitSet parents, DocIdSetIterator children) {
        NumericDocValues values;
        switch (selection) {
            case MIN: {
                values = SortedNumericSelector.wrap(sortedNumerics, SortedNumericSelector.Type.MIN, SortField.Type.LONG);
                break;
            }
            case MAX: {
                values = SortedNumericSelector.wrap(sortedNumerics, SortedNumericSelector.Type.MAX, SortField.Type.LONG);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BlockJoinSelector.wrap(values, selection, parents, children);
    }

    @Deprecated
    public static NumericDocValues wrap(NumericDocValues values, Type selection, BitSet parents, BitSet children) {
        return BlockJoinSelector.wrap(values, selection, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
    }

    public static NumericDocValues wrap(NumericDocValues values, Type selection, BitSet parents, DocIdSetIterator children) {
        if (values.docID() != -1) {
            throw new IllegalArgumentException("values iterator was already consumed: values.docID=" + values.docID());
        }
        return ToParentDocValues.wrap(values, selection, parents, children);
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

