/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.elastic.ElasticClients;
import com.hazelcast.jet.elastic.ElasticSourceBuilder;
import com.hazelcast.jet.pipeline.BatchSource;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.search.SearchHit;

public final class ElasticSources {
    private ElasticSources() {
    }

    @Nonnull
    public static BatchSource<String> elastic() {
        SupplierEx & Serializable client = ElasticClients::client;
        return ElasticSources.elastic((SupplierEx<RestClientBuilder>)client);
    }

    @Nonnull
    public static BatchSource<String> elastic(@Nonnull SupplierEx<RestClientBuilder> clientFn) {
        return ElasticSources.elastic(clientFn, SearchHit::getSourceAsString);
    }

    @Nonnull
    public static <T> BatchSource<T> elastic(@Nonnull FunctionEx<? super SearchHit, T> mapToItemFn) {
        return ElasticSources.elastic((SupplierEx<RestClientBuilder>)((SupplierEx & Serializable)ElasticClients::client), mapToItemFn);
    }

    @Nonnull
    public static <T> BatchSource<T> elastic(@Nonnull SupplierEx<RestClientBuilder> clientFn, @Nonnull FunctionEx<? super SearchHit, T> mapToItemFn) {
        return ElasticSources.elastic(clientFn, (SupplierEx<SearchRequest>)((SupplierEx & Serializable)SearchRequest::new), mapToItemFn);
    }

    @Nonnull
    public static <T> BatchSource<T> elastic(@Nonnull SupplierEx<RestClientBuilder> clientFn, @Nonnull SupplierEx<SearchRequest> searchRequestFn, @Nonnull FunctionEx<? super SearchHit, T> mapToItemFn) {
        return ElasticSources.builder().clientFn(clientFn).searchRequestFn(searchRequestFn).mapToItemFn(mapToItemFn).build();
    }

    @Nonnull
    public static ElasticSourceBuilder<Void> builder() {
        return new ElasticSourceBuilder<Void>();
    }
}

