/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hadoop.fs.azurebfs.utils.IdentityHandler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFileBasedIdentityHandler
implements IdentityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TextFileBasedIdentityHandler.class);
    private static final int NO_OF_FIELDS_USER_MAPPING = 6;
    private static final int NO_OF_FIELDS_GROUP_MAPPING = 4;
    private static final int ARRAY_INDEX_FOR_LOCAL_USER_NAME = 1;
    private static final int ARRAY_INDEX_FOR_LOCAL_GROUP_NAME = 1;
    private static final int ARRAY_INDEX_FOR_AAD_SP_OBJECT_ID = 0;
    private static final int ARRAY_INDEX_FOR_AAD_SG_OBJECT_ID = 0;
    private String userMappingFileLocation;
    private String groupMappingFileLocation;
    private HashMap<String, String> userMap;
    private HashMap<String, String> groupMap;

    public TextFileBasedIdentityHandler(String userMappingFilePath, String groupMappingFilePath) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(userMappingFilePath), "Local User to Service Principal mapping filePath cannot by Null or Empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(groupMappingFilePath), "Local Group to Security Group mapping filePath cannot by Null or Empty");
        this.userMappingFileLocation = userMappingFilePath;
        this.groupMappingFileLocation = groupMappingFilePath;
        this.userMap = new HashMap();
        this.groupMap = new HashMap();
    }

    @Override
    public synchronized String lookupForLocalUserIdentity(String originalIdentity) throws IOException {
        if (Strings.isNullOrEmpty(originalIdentity)) {
            return "";
        }
        if (this.userMap.size() == 0) {
            TextFileBasedIdentityHandler.loadMap(this.userMap, this.userMappingFileLocation, 6, 0);
        }
        try {
            String username = !Strings.isNullOrEmpty(this.userMap.get(originalIdentity)) ? this.userMap.get(originalIdentity).split(":")[1] : "";
            return username;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error("Error while parsing the line, returning empty string", e);
            return "";
        }
    }

    @Override
    public synchronized String lookupForLocalGroupIdentity(String originalIdentity) throws IOException {
        if (Strings.isNullOrEmpty(originalIdentity)) {
            return "";
        }
        if (this.groupMap.size() == 0) {
            TextFileBasedIdentityHandler.loadMap(this.groupMap, this.groupMappingFileLocation, 4, 0);
        }
        try {
            String groupname = !Strings.isNullOrEmpty(this.groupMap.get(originalIdentity)) ? this.groupMap.get(originalIdentity).split(":")[1] : "";
            return groupname;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error("Error while parsing the line, returning empty string", e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMap(HashMap<String, String> cache, String fileLocation, int noOfFields, int keyIndex) throws IOException {
        LOG.debug("Loading identity map from file {}", (Object)fileLocation);
        int errorRecord = 0;
        File file = new File(fileLocation);
        LineIterator it = null;
        try {
            it = FileUtils.lineIterator(file, "UTF-8");
            while (it.hasNext()) {
                String line = it.nextLine();
                if (Strings.isNullOrEmpty(line.trim()) || line.startsWith("#")) continue;
                if (line.split(":").length != noOfFields) {
                    ++errorRecord;
                    continue;
                }
                cache.put(line.split(":")[keyIndex], line);
            }
            LOG.debug("Loaded map stats - File: {}, Loaded: {}, Error: {} ", fileLocation, cache.size(), errorRecord);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            try {
                LOG.error("Error while parsing mapping file", e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(LOG, it);
                throw throwable;
            }
            IOUtils.cleanupWithLogger(LOG, it);
        }
        IOUtils.cleanupWithLogger(LOG, it);
    }
}

