/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.AbfsStreamContext;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsInputStreamContext
extends AbfsStreamContext {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsInputStream.class);
    private int readBufferSize;
    private int readAheadQueueDepth;
    private boolean tolerateOobAppends;
    private boolean isReadAheadEnabled = true;
    private boolean alwaysReadBufferSize;
    private int readAheadBlockSize;
    private int readAheadRange;
    private AbfsInputStreamStatistics streamStatistics;
    private boolean readSmallFilesCompletely;
    private boolean optimizeFooterRead;
    private boolean bufferedPreadDisabled;

    public AbfsInputStreamContext(long sasTokenRenewPeriodForStreamsInSeconds) {
        super(sasTokenRenewPeriodForStreamsInSeconds);
    }

    public AbfsInputStreamContext withReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public AbfsInputStreamContext withReadAheadQueueDepth(int readAheadQueueDepth) {
        this.readAheadQueueDepth = readAheadQueueDepth >= 0 ? readAheadQueueDepth : Runtime.getRuntime().availableProcessors();
        return this;
    }

    public AbfsInputStreamContext withTolerateOobAppends(boolean tolerateOobAppends) {
        this.tolerateOobAppends = tolerateOobAppends;
        return this;
    }

    public AbfsInputStreamContext isReadAheadEnabled(boolean isReadAheadEnabled) {
        this.isReadAheadEnabled = isReadAheadEnabled;
        return this;
    }

    public AbfsInputStreamContext withReadAheadRange(int readAheadRange) {
        this.readAheadRange = readAheadRange;
        return this;
    }

    public AbfsInputStreamContext withStreamStatistics(AbfsInputStreamStatistics streamStatistics) {
        this.streamStatistics = streamStatistics;
        return this;
    }

    public AbfsInputStreamContext withReadSmallFilesCompletely(boolean readSmallFilesCompletely) {
        this.readSmallFilesCompletely = readSmallFilesCompletely;
        return this;
    }

    public AbfsInputStreamContext withOptimizeFooterRead(boolean optimizeFooterRead) {
        this.optimizeFooterRead = optimizeFooterRead;
        return this;
    }

    public AbfsInputStreamContext withShouldReadBufferSizeAlways(boolean alwaysReadBufferSize) {
        this.alwaysReadBufferSize = alwaysReadBufferSize;
        return this;
    }

    public AbfsInputStreamContext withReadAheadBlockSize(int readAheadBlockSize) {
        this.readAheadBlockSize = readAheadBlockSize;
        return this;
    }

    public AbfsInputStreamContext withBufferedPreadDisabled(boolean bufferedPreadDisabled) {
        this.bufferedPreadDisabled = bufferedPreadDisabled;
        return this;
    }

    public AbfsInputStreamContext build() {
        if (this.readBufferSize > this.readAheadBlockSize) {
            LOG.debug("fs.azure.read.request.size[={}] is configured for higher size than fs.azure.read.readahead.blocksize[={}]. Auto-align readAhead block size to be same as readRequestSize.", (Object)this.readBufferSize, (Object)this.readAheadBlockSize);
            this.readAheadBlockSize = this.readBufferSize;
        }
        Preconditions.checkArgument(this.readAheadRange > 0, "Read ahead range should be greater than 0");
        return this;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    public boolean isTolerateOobAppends() {
        return this.tolerateOobAppends;
    }

    public boolean isReadAheadEnabled() {
        return this.isReadAheadEnabled;
    }

    public int getReadAheadRange() {
        return this.readAheadRange;
    }

    public AbfsInputStreamStatistics getStreamStatistics() {
        return this.streamStatistics;
    }

    public boolean readSmallFilesCompletely() {
        return this.readSmallFilesCompletely;
    }

    public boolean optimizeFooterRead() {
        return this.optimizeFooterRead;
    }

    public boolean shouldReadBufferSizeAlways() {
        return this.alwaysReadBufferSize;
    }

    public int getReadAheadBlockSize() {
        return this.readAheadBlockSize;
    }

    public boolean isBufferedPreadDisabled() {
        return this.bufferedPreadDisabled;
    }
}

