/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.hazelcast.com.fasterxml.jackson.core.JsonGenerator;
import com.hazelcast.com.fasterxml.jackson.core.JsonParseException;
import com.hazelcast.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.storage.core.JsonUtilities;
import java.io.IOException;

public class WrappedContentKey {
    public String algorithm;
    public byte[] encryptedKey;
    public String keyId;

    public WrappedContentKey() {
    }

    public WrappedContentKey(String keyId, byte[] encryptedKey, String algorithm) {
        this.keyId = keyId;
        this.encryptedKey = encryptedKey;
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setEncryptedKey(byte[] encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeStringField("KeyId", this.getKeyId());
        generator.writeBinaryField("EncryptedKey", this.getEncryptedKey());
        generator.writeStringField("Algorithm", this.getAlgorithm());
    }

    public static WrappedContentKey deserialize(JsonParser parser) throws JsonParseException, IOException {
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        WrappedContentKey wrappedContentKey = new WrappedContentKey();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String name = parser.getCurrentName();
            parser.nextToken();
            if (name.equals("KeyId")) {
                wrappedContentKey.setKeyId(parser.getValueAsString());
            } else if (name.equals("EncryptedKey")) {
                wrappedContentKey.setEncryptedKey(parser.getBinaryValue());
            } else if (name.equals("Algorithm")) {
                wrappedContentKey.setAlgorithm(parser.getValueAsString());
            }
            parser.nextToken();
        }
        JsonUtilities.assertIsEndObjectJsonToken(parser);
        return wrappedContentKey;
    }
}

