/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.CounterMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.GaugeMetricFamily;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardExports
extends Collector {
    private static final Logger LOGGER = Logger.getLogger(StandardExports.class.getName());
    private final StatusReader statusReader;
    private final OperatingSystemMXBean osBean;
    private final RuntimeMXBean runtimeBean;
    private final boolean linux;
    private static final double KB = 1024.0;

    public StandardExports() {
        this(new StatusReader(), ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getRuntimeMXBean());
    }

    StandardExports(StatusReader statusReader, OperatingSystemMXBean osBean, RuntimeMXBean runtimeBean) {
        this.statusReader = statusReader;
        this.osBean = osBean;
        this.runtimeBean = runtimeBean;
        this.linux = osBean.getName().indexOf("Linux") == 0;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            Long processCpuTime = StandardExports.callLongGetter("getProcessCpuTime", (Object)this.osBean);
            mfs.add(new CounterMetricFamily("process_cpu_seconds_total", "Total user and system CPU time spent in seconds.", (double)processCpuTime.longValue() / 1.0E9));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not access process cpu time", e);
        }
        mfs.add(new GaugeMetricFamily("process_start_time_seconds", "Start time of the process since unix epoch in seconds.", (double)this.runtimeBean.getStartTime() / 1000.0));
        try {
            Long openFdCount = StandardExports.callLongGetter("getOpenFileDescriptorCount", (Object)this.osBean);
            mfs.add(new GaugeMetricFamily("process_open_fds", "Number of open file descriptors.", openFdCount.longValue()));
            Long maxFdCount = StandardExports.callLongGetter("getMaxFileDescriptorCount", (Object)this.osBean);
            mfs.add(new GaugeMetricFamily("process_max_fds", "Maximum number of open file descriptors.", maxFdCount.longValue()));
        }
        catch (Exception openFdCount) {
            // empty catch block
        }
        if (this.linux) {
            try {
                this.collectMemoryMetricsLinux(mfs);
            }
            catch (Exception e) {
                LOGGER.warning(e.toString());
            }
        }
        return mfs;
    }

    static Long callLongGetter(String getterName, Object obj) throws NoSuchMethodException, InvocationTargetException {
        return StandardExports.callLongGetter(obj.getClass().getMethod(getterName, new Class[0]), obj);
    }

    static Long callLongGetter(Method method, Object obj) throws InvocationTargetException {
        try {
            return (Long)method.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            for (Class<?> clazz : method.getDeclaringClass().getInterfaces()) {
                try {
                    Method interfaceMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                    Long result = StandardExports.callLongGetter(interfaceMethod, obj);
                    if (result == null) continue;
                    return result;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectMemoryMetricsLinux(List<Collector.MetricFamilySamples> mfs) {
        BufferedReader br = null;
        try {
            String line;
            br = this.statusReader.procSelfStatusReader();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("VmSize:")) {
                    mfs.add(new GaugeMetricFamily("process_virtual_memory_bytes", "Virtual memory size in bytes.", (double)Float.parseFloat(line.split("\\s+")[1]) * 1024.0));
                    continue;
                }
                if (!line.startsWith("VmRSS:")) continue;
                mfs.add(new GaugeMetricFamily("process_resident_memory_bytes", "Resident memory size in bytes.", (double)Float.parseFloat(line.split("\\s+")[1]) * 1024.0));
            }
        }
        catch (IOException e) {
            LOGGER.fine(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.fine(e.toString());
                }
            }
        }
    }

    static class StatusReader {
        StatusReader() {
        }

        BufferedReader procSelfStatusReader() throws FileNotFoundException {
            return new BufferedReader(new FileReader("/proc/self/status"));
        }
    }
}

