/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import com.hazelcast.jet.cdc.ChangeRecord;
import com.hazelcast.jet.cdc.Operation;
import com.hazelcast.jet.cdc.impl.CdcSourceP;
import com.hazelcast.jet.cdc.impl.ChangeRecordImpl;
import com.hazelcast.jet.cdc.impl.SequenceExtractor;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.source.SourceRecord;

public class ChangeRecordCdcSourceP
extends CdcSourceP<ChangeRecord> {
    public static final String DB_SPECIFIC_EXTRA_FIELDS_PROPERTY = "db.specific.extra.fields";
    private final SequenceExtractor sequenceExtractor;

    public ChangeRecordCdcSourceP(@Nonnull Properties properties, @Nonnull EventTimePolicy<? super ChangeRecord> eventTimePolicy) {
        super(properties, eventTimePolicy);
        try {
            this.sequenceExtractor = (SequenceExtractor)ChangeRecordCdcSourceP.newInstance(properties.getProperty("sequence.extractor.class"), "sequence extractor ");
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    @Nullable
    protected ChangeRecord map(SourceRecord record) {
        Supplier<String> newValueJson;
        Supplier<String> oldValueJson;
        long timestamp;
        Operation operation;
        if (record == null) {
            return null;
        }
        long sequenceSource = this.sequenceExtractor.source(record.sourcePartition(), record.sourceOffset());
        long sequenceValue = this.sequenceExtractor.sequence(record.sourceOffset());
        String keyJson = Values.convertToString(record.keySchema(), record.key());
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        Struct source = (Struct)value.get("source");
        Operation operation2 = operation = value.schema().field("op") != null ? Operation.get(value.getString("op")) : Operation.UNSPECIFIED;
        if (operation == Operation.UNSPECIFIED) {
            timestamp = ((Struct)value.get("source")).getInt64("ts_ms");
            oldValueJson = () -> Values.convertToString(valueSchema, value);
            newValueJson = () -> Values.convertToString(valueSchema, value);
        } else {
            Object before = valueSchema.field("before") != null ? value.get("before") : null;
            Object after = valueSchema.field("after") != null ? value.get("after") : null;
            timestamp = value.getInt64("ts_ms");
            oldValueJson = before == null ? null : () -> Values.convertToString(valueSchema.field("before").schema(), before);
            newValueJson = after == null ? null : () -> Values.convertToString(valueSchema.field("after").schema(), after);
        }
        return new ChangeRecordImpl(timestamp, sequenceSource, sequenceValue, operation, keyJson, oldValueJson, newValueJson, ChangeRecordCdcSourceP.fieldOrNull(source, "table"), ChangeRecordCdcSourceP.fieldOrNull(source, "schema"), ChangeRecordCdcSourceP.fieldOrNull(source, "db"));
    }

    private static String fieldOrNull(Struct struct, String fieldName) {
        return struct.schema().field(fieldName) != null ? struct.getString(fieldName) : null;
    }
}

