/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.annotation.EvolvingApi;
import com.hazelcast.jet.cdc.ChangeRecord;
import com.hazelcast.jet.cdc.impl.CdcSourceP;
import com.hazelcast.jet.cdc.impl.ChangeRecordCdcSourceP;
import com.hazelcast.jet.cdc.impl.ConstantSequenceExtractor;
import com.hazelcast.jet.cdc.impl.DebeziumConfig;
import com.hazelcast.jet.cdc.impl.JsonCdcSourceP;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.source.SourceConnector;

@EvolvingApi
public final class DebeziumCdcSources {
    private DebeziumCdcSources() {
    }

    @Nonnull
    public static Builder<ChangeRecord> debezium(@Nonnull String name, @Nonnull String connectorClass) {
        return new Builder<ChangeRecord>(name, connectorClass, (BiFunctionEx & Serializable)(properties, eventTimePolicy) -> new ChangeRecordCdcSourceP((Properties)properties, (EventTimePolicy<? super ChangeRecord>)eventTimePolicy));
    }

    @Nonnull
    public static Builder<ChangeRecord> debezium(@Nonnull String name, @Nonnull Class<?> connectorClass) {
        Preconditions.checkState((boolean)SourceConnector.class.isAssignableFrom(connectorClass), (String)"connector class must be a subclass of SourceConnector");
        return new Builder<ChangeRecord>(name, connectorClass.getName(), (BiFunctionEx & Serializable)(properties, eventTimePolicy) -> new ChangeRecordCdcSourceP((Properties)properties, (EventTimePolicy<? super ChangeRecord>)eventTimePolicy));
    }

    @Nonnull
    public static Builder<Map.Entry<String, String>> debeziumJson(@Nonnull String name, @Nonnull String connectorClass) {
        return new Builder<Map.Entry<String, String>>(name, connectorClass, (BiFunctionEx & Serializable)(properties, eventTimePolicy) -> new JsonCdcSourceP((Properties)properties, (EventTimePolicy<? super Map.Entry<String, String>>)eventTimePolicy));
    }

    @Nonnull
    public static Builder<Map.Entry<String, String>> debeziumJson(@Nonnull String name, @Nonnull Class<?> connectorClass) {
        Preconditions.checkState((boolean)SourceConnector.class.isAssignableFrom(connectorClass), (String)"connector class must be a subclass of SourceConnector");
        return new Builder<Map.Entry<String, String>>(name, connectorClass.getName(), (BiFunctionEx & Serializable)(properties, eventTimePolicy) -> new JsonCdcSourceP((Properties)properties, (EventTimePolicy<? super Map.Entry<String, String>>)eventTimePolicy));
    }

    public static final class Builder<T> {
        private final BiFunctionEx<Properties, EventTimePolicy<? super T>, CdcSourceP<T>> createProcessorFn;
        private final DebeziumConfig config;

        private Builder(@Nonnull String name, @Nonnull String connectorClass, @Nonnull BiFunctionEx<Properties, EventTimePolicy<? super T>, CdcSourceP<T>> createProcessorFn) {
            this.config = new DebeziumConfig(name, connectorClass);
            this.config.setProperty("sequence.extractor.class", ConstantSequenceExtractor.class.getName());
            this.createProcessorFn = createProcessorFn;
        }

        @Nonnull
        public Builder<T> setProperty(@Nonnull String key, @Nonnull String value) {
            this.config.setProperty(key, value);
            return this;
        }

        @Nonnull
        public StreamSource<T> build() {
            Properties properties = this.config.toProperties();
            BiFunctionEx createProcessorFn = this.createProcessorFn;
            return Sources.streamFromProcessorWithWatermarks((String)properties.getProperty("name"), (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> {
                ProcessorSupplier supplier = ProcessorSupplier.of((SupplierEx & Serializable)() -> (CdcSourceP)((Object)((Object)((Object)createProcessorFn.apply((Object)properties, eventTimePolicy)))));
                return ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)supplier);
            });
        }
    }
}

