/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.logging.ILogger;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TimeoutException;

public final class StreamKafkaP<K, V, T>
extends AbstractProcessor {
    public static final int PREFERRED_LOCAL_PARALLELISM = 4;
    private static final long METADATA_CHECK_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(5L);
    private static final String PARTITION_COUNTS_SNAPSHOT_KEY = "partitionCounts";
    Map<TopicPartition, Integer> currentAssignment = new HashMap<TopicPartition, Integer>();
    private final Properties properties;
    private final FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn;
    private final EventTimeMapper<? super T> eventTimeMapper;
    private List<String> topics;
    private int totalParallelism;
    private KafkaConsumer<K, V> consumer;
    private long nextMetadataCheck = Long.MIN_VALUE;
    private final Map<String, long[]> offsets = new HashMap<String, long[]>();
    private Traverser<Map.Entry<BroadcastKey<?>, ?>> snapshotTraverser;
    private int processorIndex;
    private Traverser<Object> traverser = Traversers.empty();

    public StreamKafkaP(@Nonnull Properties properties, @Nonnull List<String> topics, @Nonnull FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        this.properties = properties;
        this.topics = topics;
        this.projectionFn = projectionFn;
        this.eventTimeMapper = new EventTimeMapper(eventTimePolicy);
        for (String topic : topics) {
            this.offsets.put(topic, new long[0]);
        }
    }

    public boolean isCooperative() {
        return false;
    }

    protected void init(@Nonnull Processor.Context context) {
        List uniqueTopics = this.topics.stream().distinct().collect(Collectors.toList());
        if (uniqueTopics.size() != this.topics.size()) {
            ArrayList<String> topics = new ArrayList<String>(this.topics);
            for (String t : uniqueTopics) {
                topics.remove(t);
            }
            this.getLogger().warning("Duplicate topics found in topic list: " + topics);
        }
        this.topics = uniqueTopics;
        this.processorIndex = context.globalProcessorIndex();
        this.totalParallelism = context.totalParallelism();
        this.consumer = new KafkaConsumer(this.properties);
    }

    private void assignPartitions() {
        if (System.nanoTime() < this.nextMetadataCheck) {
            return;
        }
        for (int topicIndex = 0; topicIndex < this.topics.size(); ++topicIndex) {
            int newPartitionCount;
            String topicName = this.topics.get(topicIndex);
            try {
                List<PartitionInfo> partitionInfo = this.consumer.partitionsFor(topicName, Duration.ofSeconds(1L));
                newPartitionCount = partitionInfo == null ? 0 : partitionInfo.size();
            }
            catch (TimeoutException e) {
                this.getLogger().warning("Unable to get partition metadata, ignoring: " + e, (Throwable)e);
                return;
            }
            this.handleNewPartitions(topicIndex, newPartitionCount, false);
        }
        this.nextMetadataCheck = System.nanoTime() + METADATA_CHECK_INTERVAL_NANOS;
    }

    private void handleNewPartitions(int topicIndex, int newPartitionCount, boolean isRestoring) {
        String topicName = this.topics.get(topicIndex);
        long[] oldTopicOffsets = this.offsets.get(topicName);
        if (oldTopicOffsets.length >= newPartitionCount) {
            return;
        }
        long[] newOffsets = Arrays.copyOf(oldTopicOffsets, newPartitionCount);
        Arrays.fill(newOffsets, oldTopicOffsets.length, newOffsets.length, -1L);
        this.offsets.put(topicName, newOffsets);
        ArrayList<TopicPartition> newAssignments = new ArrayList<TopicPartition>();
        for (int partition = oldTopicOffsets.length; partition < newPartitionCount; ++partition) {
            if (!this.handledByThisProcessor(topicIndex, partition)) continue;
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.currentAssignment.put(tp, this.currentAssignment.size());
            newAssignments.add(tp);
        }
        if (newAssignments.isEmpty()) {
            return;
        }
        this.getLogger().info("New partition(s) assigned: " + newAssignments);
        this.eventTimeMapper.addPartitions(newAssignments.size());
        this.consumer.assign(this.currentAssignment.keySet());
        if (oldTopicOffsets.length > 0 && !isRestoring) {
            this.getLogger().info("Seeking to the beginning of newly-discovered partitions: " + newAssignments);
            this.consumer.seekToBeginning(newAssignments);
        }
        LoggingUtil.logFinest((ILogger)this.getLogger(), (String)"Currently assigned partitions: %s", this.currentAssignment);
    }

    public boolean complete() {
        if (!this.emitFromTraverser(this.traverser)) {
            return false;
        }
        ConsumerRecords<K, V> records = null;
        this.assignPartitions();
        if (!this.currentAssignment.isEmpty()) {
            records = this.consumer.poll(Duration.ZERO);
        }
        this.traverser = this.isEmpty(records) ? this.eventTimeMapper.flatMapIdle() : Traversers.traverseIterable(records).flatMap(record -> {
            this.offsets.get((Object)record.topic())[record.partition()] = record.offset();
            Object projectedRecord = this.projectionFn.apply(record);
            if (projectedRecord == null) {
                return Traversers.empty();
            }
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            return this.eventTimeMapper.flatMapEvent(projectedRecord, this.currentAssignment.get(topicPartition).intValue(), record.timestamp());
        });
        this.emitFromTraverser(this.traverser);
        return false;
    }

    public void close() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (InterruptException interruptException) {
                // empty catch block
            }
        }
    }

    public boolean saveToSnapshot() {
        if (!this.emitFromTraverser(this.traverser)) {
            return false;
        }
        if (this.snapshotTraverser == null) {
            Stream snapshotStream = this.offsets.entrySet().stream().flatMap(entry -> IntStream.range(0, ((long[])entry.getValue()).length).filter(partition -> ((long[])entry.getValue())[partition] >= 0L).mapToObj(partition -> {
                TopicPartition key = new TopicPartition((String)entry.getKey(), partition);
                long offset = ((long[])entry.getValue())[partition];
                long watermark = this.eventTimeMapper.getWatermark(this.currentAssignment.get(key).intValue());
                return Util.entry((Object)BroadcastKey.broadcastKey((Object)key), (Object)new long[]{offset, watermark});
            }));
            this.snapshotTraverser = Traversers.traverseStream(snapshotStream).onFirstNull(() -> {
                this.snapshotTraverser = null;
                if (this.getLogger().isFinestEnabled()) {
                    this.getLogger().finest("Finished saving snapshot. Saved offsets: " + this.offsets() + ", Saved watermarks: " + this.watermarks());
                }
            });
            if (this.processorIndex == 0) {
                Map.Entry partitionCountsItem = Util.entry((Object)BroadcastKey.broadcastKey((Object)PARTITION_COUNTS_SNAPSHOT_KEY), this.topics.stream().collect(Collectors.toMap(topic -> topic, topic -> this.offsets.get(topic).length)));
                this.snapshotTraverser = this.snapshotTraverser.append((Object)partitionCountsItem);
            }
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    public void restoreFromSnapshot(@Nonnull Object key0, @Nonnull Object value) {
        Object key = ((BroadcastKey)key0).key();
        if (PARTITION_COUNTS_SNAPSHOT_KEY.equals(key)) {
            Map partitionCounts = (Map)value;
            for (Map.Entry partitionCountEntry : partitionCounts.entrySet()) {
                String topicName = (String)partitionCountEntry.getKey();
                int partitionCount = (Integer)partitionCountEntry.getValue();
                int topicIndex = this.topics.indexOf(topicName);
                assert (topicIndex >= 0);
                this.handleNewPartitions(topicIndex, partitionCount, true);
            }
        } else {
            TopicPartition topicPartition = (TopicPartition)key;
            long[] value1 = (long[])value;
            long offset = value1[0];
            long watermark = value1[1];
            if (!this.offsets.containsKey(topicPartition.topic())) {
                this.getLogger().warning("Offset for topic '" + topicPartition.topic() + "' is restored from the snapshot, but the topic is not supposed to be read, ignoring");
                return;
            }
            int topicIndex = this.topics.indexOf(topicPartition.topic());
            assert (topicIndex >= 0);
            this.handleNewPartitions(topicIndex, topicPartition.partition() + 1, true);
            if (!this.handledByThisProcessor(topicIndex, topicPartition.partition())) {
                return;
            }
            long[] topicOffsets = this.offsets.get(topicPartition.topic());
            assert (topicOffsets[topicPartition.partition()] < 0L) : "duplicate offset for topicPartition '" + topicPartition + "' restored, offset1=" + topicOffsets[topicPartition.partition()] + ", offset2=" + offset;
            topicOffsets[topicPartition.partition()] = offset;
            this.consumer.seek(topicPartition, offset + 1L);
            Integer partitionIndex = this.currentAssignment.get(topicPartition);
            assert (partitionIndex != null);
            this.eventTimeMapper.restoreWatermark(partitionIndex.intValue(), watermark);
        }
    }

    public boolean finishSnapshotRestore() {
        if (this.getLogger().isFineEnabled()) {
            this.getLogger().fine("Finished restoring snapshot. Restored offsets: " + this.offsets() + " and watermarks:" + this.watermarks());
        }
        return true;
    }

    private boolean isEmpty(ConsumerRecords<K, V> records) {
        return records == null || records.isEmpty();
    }

    private Map<TopicPartition, Long> offsets() {
        return this.currentAssignment.keySet().stream().collect(Collectors.toMap(tp -> tp, tp -> this.offsets.get(tp.topic())[tp.partition()]));
    }

    private Map<TopicPartition, Long> watermarks() {
        return this.currentAssignment.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.eventTimeMapper.getWatermark(((Integer)e.getValue()).intValue())));
    }

    @Nonnull
    public static <K, V, T> SupplierEx<Processor> processorSupplier(@Nonnull Properties properties, @Nonnull List<String> topics, @Nonnull FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        return (SupplierEx & Serializable)() -> new StreamKafkaP(properties, topics, projectionFn, eventTimePolicy);
    }

    private boolean handledByThisProcessor(int topicIndex, int partition) {
        return StreamKafkaP.handledByThisProcessor(this.totalParallelism, this.offsets.size(), this.processorIndex, topicIndex, partition);
    }

    static boolean handledByThisProcessor(int totalParallelism, int topicsCount, int processorIndex, int topicIndex, int partition) {
        int startIndex = topicIndex * Math.max(1, totalParallelism / topicsCount);
        int topicPartitionHandledBy = (startIndex + partition) % totalParallelism;
        return topicPartitionHandledBy == processorIndex;
    }
}

