/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.sql.SqlColumnMetadata;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Queries {
    private final String loadQuery;
    private final Function<Integer, String> loadAllFactory;
    private final Map<Integer, String> loadAllQueries = new ConcurrentHashMap<Integer, String>();
    private final String loadAllKeys;
    private final String storeInsert;
    private final String storeUpdate;
    private final String delete;
    private final Function<Integer, String> deleteAllFactory;
    private final Map<Integer, String> deleteAllQueries = new ConcurrentHashMap<Integer, String>();

    Queries(String mapping, String idColumn, List<SqlColumnMetadata> columnMetadata) {
        this.loadQuery = "SELECT * FROM \"" + mapping + "\" WHERE \"" + idColumn + "\" = ?";
        this.loadAllFactory = n -> "SELECT * FROM \"" + mapping + "\" WHERE \"" + idColumn + "\" IN (" + this.queryParams(n.intValue()) + ")";
        this.loadAllKeys = "SELECT \"" + idColumn + "\" FROM \"" + mapping + "\"";
        String columnNames = columnMetadata.stream().map(sqlColumnMetadata -> '\"' + sqlColumnMetadata.getName() + '\"').collect(Collectors.joining(", "));
        this.storeInsert = "INSERT INTO \"" + mapping + "\" ( " + columnNames + " ) VALUES (" + this.queryParams(columnMetadata.size()) + ")";
        String setClause = columnMetadata.stream().filter(cm -> !idColumn.equals(cm.getName())).map(cm -> '\"' + cm.getName() + "\" = ?").collect(Collectors.joining(", "));
        this.storeUpdate = "UPDATE \"" + mapping + "\" SET " + setClause + " WHERE \"" + idColumn + "\" = ?";
        this.delete = "DELETE FROM \"" + mapping + "\" WHERE \"" + idColumn + "\" = ?";
        this.deleteAllFactory = n -> "DELETE FROM \"" + mapping + "\" WHERE \"" + idColumn + "\" IN (" + this.queryParams(n.intValue()) + ")";
    }

    private String queryParams(long n) {
        return Stream.generate(() -> "?").limit(n).collect(Collectors.joining(", "));
    }

    String load() {
        return this.loadQuery;
    }

    String loadAll(int n) {
        return this.loadAllQueries.computeIfAbsent(n, this.loadAllFactory);
    }

    String loadAllKeys() {
        return this.loadAllKeys;
    }

    String storeInsert() {
        return this.storeInsert;
    }

    String storeUpdate() {
        return this.storeUpdate;
    }

    String delete() {
        return this.delete;
    }

    String deleteAll(int n) {
        return this.deleteAllQueries.computeIfAbsent(n, this.deleteAllFactory);
    }
}

